/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus;

import com.simiacryptus.binary.Bits;
import java.io.IOException;
import java.util.Random;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.Test;

public class BitsTest {
    Random random = new Random();

    private long randomLong() {
        return this.random.nextLong() >> this.random.nextInt(62);
    }

    @Test
    public void testConcatenate() throws JSONException, IOException {
        for (int i = 0; i < 1000; ++i) {
            this.testConcatenate(this.randomLong(), this.randomLong());
        }
    }

    private void testConcatenate(long a, long b) {
        String asStringA = 0L == a ? "" : Long.toBinaryString(a);
        String asStringB = 0L == b ? "" : Long.toBinaryString(b);
        String asString = asStringA + asStringB;
        Bits bitsA = new Bits(a);
        Bits bitsB = new Bits(b);
        Bits bits = bitsA.concatenate(bitsB);
        Assert.assertEquals((String)String.format("Concatenate %s and %s", a, b), (Object)asString, (Object)bits.toBitString());
    }

    @Test
    public void testFixedLength() throws JSONException, IOException {
        for (int i = 0; i < 1000; ++i) {
            this.testFixedLength(this.randomLong());
        }
    }

    private void testFixedLength(long value) {
        String asString = 0L == value ? "" : Long.toBinaryString(value);
        Bits bits = new Bits(value, 64);
        while (asString.length() < 64) {
            asString = "0" + asString;
        }
        Assert.assertEquals((String)("toLong for " + value), (long)value, (long)bits.toLong());
        Assert.assertEquals((String)("toString for " + value), (Object)asString, (Object)bits.toBitString());
    }

    @Test
    public void testHardcoded() throws JSONException, IOException {
        Assert.assertEquals((Object)new Bits(0L), (Object)new Bits(0L));
        Assert.assertEquals((Object)"", (Object)new Bits(0L).toBitString());
        Assert.assertEquals((Object)"1", (Object)new Bits(1L).toBitString());
        Assert.assertEquals((Object)"100", (Object)new Bits(4L).toBitString());
        Assert.assertEquals((Object)"10001", (Object)new Bits(17L).toBitString());
        Assert.assertEquals((Object)"100", (Object)new Bits(17L).range(0, 3).toBitString());
        Assert.assertEquals((Object)"01", (Object)new Bits(17L).range(3).toBitString());
        Assert.assertEquals((Object)"111", (Object)new Bits(7L).toBitString());
        Assert.assertEquals((Object)"10111", (Object)new Bits(2L).concatenate(new Bits(7L)).toBitString());
        Assert.assertEquals((Object)"00110", (Object)new Bits(6L, 5).toBitString());
        Assert.assertEquals((Object)"111000000", (Object)new Bits(7L).leftShift(6).toBitString());
        Assert.assertEquals((Object)"1110", (Object)new Bits(7L).leftShift(6).range(0, 4).toBitString());
        Assert.assertEquals((Object)"00000", (Object)new Bits(7L).leftShift(6).range(4).toBitString());
        Assert.assertEquals((Object)"110", (Object)new Bits(6L).toBitString());
        Assert.assertEquals((Object)"11100", (Object)new Bits(7L).leftShift(2).toBitString());
        Assert.assertEquals((Object)"11000", (Object)new Bits(7L).leftShift(2).bitwiseAnd(new Bits(6L)).toBitString());
        Assert.assertEquals((Object)"11100", (Object)new Bits(7L).leftShift(2).bitwiseOr(new Bits(6L)).toBitString());
        Assert.assertEquals((Object)"00100", (Object)new Bits(7L).leftShift(2).bitwiseXor(new Bits(6L)).toBitString());
        Assert.assertEquals((long)2L, (long)new Bits(7L, 16).getBytes().length);
    }

    @Test
    public void testSubrange() throws JSONException, IOException {
        for (int i = 0; i < 1000; ++i) {
            long value = this.random.nextLong();
            Bits bits = new Bits(value);
            this.testSubrange(bits);
        }
    }

    private void testSubrange(Bits bits) {
        String asString = bits.toBitString();
        for (int j = 0; j < 10; ++j) {
            int from = this.random.nextInt(asString.length());
            int to = from + this.random.nextInt(asString.length() - from);
            this.testSubrange(bits, asString, from, to);
        }
    }

    private void testSubrange(Bits bits, String asString, int from, int to) {
        String subStr = asString.substring(from, to);
        Bits subBits = bits.range(from, to - from);
        Assert.assertEquals((String)String.format("Substring (%s,%s) of %s", from, to, bits), (Object)subStr, (Object)subBits.toBitString());
    }

    @Test
    public void testToString() throws JSONException, IOException {
        for (int i = 0; i < 1000; ++i) {
            this.testToString(this.randomLong());
        }
    }

    private void testToString(long value) {
        String asString = 0L == value ? "" : Long.toBinaryString(value);
        Bits bits = new Bits(value);
        Assert.assertEquals((String)("toLong for " + value), (long)value, (long)bits.toLong());
        Assert.assertEquals((String)("toString for " + value), (Object)asString, (Object)bits.toBitString());
    }
}

