/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.binary;

import com.simiacryptus.binary.Bits;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class BitOutputStream {
    private boolean useChecks = false;
    private OutputStream inner;
    private Bits remainder = new Bits(0L);
    static final int[] varLongDepths = new int[]{6, 16, 32, 64};

    public BitOutputStream(OutputStream inner) {
        this.inner = inner;
    }

    public synchronized void flush() throws IOException {
        this.inner.write(this.remainder.getBytes());
        this.inner.flush();
        this.remainder = new Bits(0L);
    }

    public boolean isUseChecks() {
        return this.useChecks;
    }

    public BitOutputStream setUseChecks(boolean useChecks) {
        this.useChecks = useChecks;
        return this;
    }

    public synchronized void write(Bits encode) throws IOException {
        Bits newRemainder = this.remainder.concatenate(encode);
        int newRemainingBits = newRemainder.bitLength % 8;
        Bits toWrite = newRemainder.range(0, newRemainder.bitLength - newRemainingBits);
        this.inner.write(toWrite.getBytes());
        this.remainder = newRemainder.range(toWrite.bitLength);
    }

    public void write(boolean b) throws IOException {
        this.write(new Bits(b ? 1L : 0L, 1));
    }

    public void write(double value) throws IOException {
        this.write(new Bits(Double.doubleToLongBits(value), 64));
    }

    public <T extends Enum<T>> void write(Enum<T> value) throws IOException {
        long ordinal = value.ordinal();
        this.write(new Bits(ordinal, 8));
    }

    public void write(int value) throws IOException {
        this.write(new Bits(value, 32));
    }

    public void writeBoundedLong(long value, long max) throws IOException {
        int bits;
        int n = bits = 1L >= max ? 0 : (int)Math.ceil(Math.log(max) / Math.log(2.0));
        if (this.useChecks) {
            this.write(new Bits(bits, 8));
        }
        if (0 < bits) {
            this.write(new Bits(value, bits));
        }
    }

    public void writeVarLong(long value) throws IOException {
        int bitLength = new Bits((long)value).bitLength;
        int type = Arrays.binarySearch(varLongDepths, bitLength);
        if (type < 0) {
            type = -type - 1;
        }
        this.write(new Bits(type, 2));
        this.write(new Bits(value, varLongDepths[type]));
    }
}

