/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.collections;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class CountCollection<T, C extends Map<T, AtomicInteger>> {
    protected final C map;

    public CountCollection(C collection) {
        this.map = collection;
    }

    public int add(T bits) {
        return this.getCounter(bits).incrementAndGet();
    }

    public int add(T bits, int count) {
        return this.getCounter(bits).addAndGet(count);
    }

    protected int count(T key) {
        AtomicInteger counter = (AtomicInteger)this.map.get(key);
        if (null == counter) {
            return 0;
        }
        return counter.get();
    }

    private AtomicInteger getCounter(T bits) {
        AtomicInteger counter = (AtomicInteger)this.map.get(bits);
        if (null == counter) {
            counter = new AtomicInteger();
            this.map.put(bits, (AtomicInteger)counter);
        }
        return counter;
    }

    public List<T> getList() {
        ArrayList list = new ArrayList();
        for (Map.Entry e : this.map.entrySet()) {
            for (int i = 0; i < ((AtomicInteger)e.getValue()).get(); ++i) {
                list.add(e.getKey());
            }
        }
        return list;
    }

    public Map<T, Integer> getMap() {
        return Maps.transformEntries(this.map, (Maps.EntryTransformer)new Maps.EntryTransformer<T, AtomicInteger, Integer>(){

            public Integer transformEntry(T key, AtomicInteger value) {
                return value.get();
            }
        });
    }
}

