/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ObjUtil {
    private static JSONArray toArray(Iterable<?> value, HashSet<ObjId> stack) throws IllegalArgumentException, JSONException, IllegalAccessException {
        JSONArray array = new JSONArray();
        for (Object v : value) {
            if (null == v) {
                array.put(null);
                continue;
            }
            array.put((Object)ObjUtil.toJson(v, stack));
        }
        return array;
    }

    private static JSONArray toArray(Object[] x, HashSet<ObjId> stack) throws IllegalArgumentException, JSONException, IllegalAccessException {
        JSONArray array = new JSONArray();
        for (Object v : x) {
            if (null == v) {
                array.put(null);
                continue;
            }
            array.put((Object)ObjUtil.toJson(v, stack));
        }
        return array;
    }

    public static JSONObject toJson(Object obj) throws JSONException, IllegalArgumentException, IllegalAccessException {
        return ObjUtil.toJson(obj, new HashSet<ObjId>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject toJson(Object obj, HashSet<ObjId> stack) throws JSONException, IllegalArgumentException, IllegalAccessException {
        JSONObject json;
        ObjId id = new ObjId(obj);
        if (!stack.add(id)) {
            return null;
        }
        try {
            json = new JSONObject();
            json.put("_id", (Object)new ObjId(obj).toString());
            if (List.class.isAssignableFrom(obj.getClass())) {
                json.put("elements", (Object)ObjUtil.toArray((List)obj, stack));
            } else if (Map.class.isAssignableFrom(obj.getClass())) {
                json.put("entries", (Object)ObjUtil.toArray(((Map)obj).entrySet(), stack));
            }
            for (Field f : obj.getClass().getDeclaredFields()) {
                if (0 != (f.getModifiers() & 8) || 0 != (f.getModifiers() & 2)) continue;
                f.setAccessible(true);
                Object value = f.get(obj);
                if (null == value) continue;
                if (f.getType().isPrimitive()) {
                    if (Double.TYPE.isAssignableFrom(f.getType())) {
                        json.put(f.getName(), ((Double)value).doubleValue());
                        continue;
                    }
                    if (Double.class.isAssignableFrom(f.getType())) {
                        json.put(f.getName(), ((Double)value).doubleValue());
                        continue;
                    }
                    if (Integer.TYPE.isAssignableFrom(f.getType())) {
                        json.put(f.getName(), ((Integer)value).intValue());
                        continue;
                    }
                    if (Integer.class.isAssignableFrom(f.getType())) {
                        json.put(f.getName(), ((Integer)value).intValue());
                        continue;
                    }
                    if (Long.class.isAssignableFrom(f.getType())) {
                        json.put(f.getName(), ((Long)value).longValue());
                        continue;
                    }
                    if (Long.TYPE.isAssignableFrom(f.getType())) {
                        json.put(f.getName(), ((Long)value).longValue());
                        continue;
                    }
                    if (Boolean.class.isAssignableFrom(f.getType())) {
                        json.put(f.getName(), ((Boolean)value).booleanValue());
                        continue;
                    }
                    if (Boolean.TYPE.isAssignableFrom(f.getType())) {
                        json.put(f.getName(), ((Boolean)value).booleanValue());
                        continue;
                    }
                    throw new RuntimeException(f.toString());
                }
                if (String.class.isAssignableFrom(f.getType())) {
                    json.put(f.getName(), value);
                    continue;
                }
                if (value.getClass().isArray()) {
                    if (int[].class.isAssignableFrom(f.getType())) {
                        json.put(f.getName(), value);
                        continue;
                    }
                    if (double[].class.isAssignableFrom(f.getType())) {
                        json.put(f.getName(), value);
                        continue;
                    }
                    if (char[].class.isAssignableFrom(f.getType())) {
                        json.put(f.getName(), value);
                        continue;
                    }
                    json.put(f.getName(), (Object)ObjUtil.toArray((Object[])value, stack));
                    continue;
                }
                assert (!f.getType().isPrimitive());
                json.put(f.getName(), (Object)ObjUtil.toJson(value, stack));
            }
        }
        finally {
            stack.remove(id);
        }
        return json;
    }

    public static class ObjId {
        Object obj;

        public ObjId(Object obj) {
            this.obj = obj;
        }

        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (!(obj instanceof ObjId)) {
                return false;
            }
            return this.obj == ((ObjId)obj).obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.obj.getClass().getSimpleName());
            builder.append("@");
            builder.append(Integer.toHexString(System.identityHashCode(this.obj)));
            return builder.toString();
        }
    }
}

