/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.AtomicDouble;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.linear.MatrixUtils;

public class Util {
    public static <T> ArrayList<T> flatten(List<List<T>> asList) {
        ArrayList<T> list = new ArrayList<T>();
        for (List<T> list1 : asList) {
            list.addAll(list1);
        }
        return list;
    }

    public static String getId(Object obj) {
        return obj.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    public static <K, V> Function<K, V> memoize(final Function<K, V> f) {
        LoadingCache cache = CacheBuilder.newBuilder().build(new CacheLoader<K, V>(){

            public V load(K key) throws Exception {
                return f.apply(key);
            }
        });
        return k -> {
            Object v;
            try {
                v = cache.get(k);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            return v;
        };
    }

    public static <K, V> LoadingCache<K, V> newLazyMap(final Function<K, V> f) {
        return CacheBuilder.newBuilder().build(new CacheLoader<K, V>(){

            public V load(K key) throws Exception {
                return f.apply(key);
            }
        });
    }

    public static double[] normalize(double[] probs) {
        double factor = Arrays.stream(probs).sum();
        return Util.transform(probs, x -> x / factor);
    }

    public static double[] normalize2(double[] probs) {
        double factor = Math.sqrt(Arrays.stream(probs).map(x -> x * x).sum());
        return Util.transform(probs, x -> x / factor);
    }

    public static double[][] normalizeRowSum(double[][] data) {
        return Util.transform(data, double[].class, x -> {
            double normalizationFactor = Arrays.stream(x).sum();
            if (0.0 >= normalizationFactor) {
                return x;
            }
            return Util.transform(x, i -> i / normalizationFactor);
        });
    }

    public static double percentile(double[] array, double v) {
        double i = Arrays.binarySearch(array, v);
        if (i < 0.0) {
            i = -(i + 0.5);
        }
        double f = i / (double)array.length;
        double tol = 1.0E-8;
        if (f < 1.0E-8) {
            return 1.0E-8;
        }
        if (f > 0.99999999) {
            return 0.99999999;
        }
        return f;
    }

    public static String print(Consumer<PrintStream> c) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (PrintStream out = new PrintStream(byteArrayOutputStream);){
            c.accept(out);
        }
        return byteArrayOutputStream.toString();
    }

    public static double product(DoubleStream stream) {
        return Util.product(stream, v -> {
            if (Double.isNaN(v)) {
                return 1.0;
            }
            if (Double.isInfinite(v)) {
                return 1.0;
            }
            return v;
        });
    }

    public static double product(DoubleStream stream, UnivariateFunction filter) {
        Supplier<AtomicDouble> supplier = () -> new AtomicDouble(1.0);
        ObjDoubleConsumer<AtomicDouble> accum = (a, b) -> {
            double update;
            double expect;
            while (!a.compareAndSet(expect = a.get(), update = filter.value(filter.value(expect) * filter.value(b)))) {
            }
        };
        BiConsumer<AtomicDouble, AtomicDouble> combiner = (a, b) -> {
            double update;
            double expect;
            while (!a.compareAndSet(expect = a.get(), update = filter.value(filter.value(expect) * filter.value(b.get())))) {
            }
        };
        double product = stream.collect(supplier, accum, combiner).get();
        return product;
    }

    public static double[] transform(double[] from, UnivariateFunction f) {
        double[] to = new double[from.length];
        Arrays.setAll(to, i -> f.value(from[i]));
        return to;
    }

    public static <F, T> T[] transform(F[] from, Class<T> object, Function<F, T> f) {
        Object[] to = (Object[])Array.newInstance(object, from.length);
        Arrays.setAll(to, i -> f.apply(from[i]));
        return to;
    }

    public static <F> double[] transform(F[] from, ToDoubleFunction<F> f) {
        double[] to = new double[from.length];
        Arrays.setAll(to, i -> f.applyAsDouble(from[i]));
        return to;
    }

    public static double[][] transpose(double[][] data) {
        return MatrixUtils.createRealMatrix((double[][])data).transpose().getData();
    }

    public static double[] unwrap(Double[] values) {
        double[] result = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i];
        }
        return result;
    }

    public static double[] unwrap(List<Double> values) {
        double[] result = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            result[i] = values.get(i);
        }
        return result;
    }

    public static Double[] wrap(double[] values) {
        Double[] result = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i];
        }
        return result;
    }

    public static Integer[] wrap(int[] values) {
        Integer[] result = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i];
        }
        return result;
    }
}

