/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.simiacryptus.util.StreamNanoHTTPD;
import fi.iki.elonen.NanoHTTPD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class FileNanoHTTPD
extends NanoHTTPD {
    public final Map<CharSequence, Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response>> handlers = new HashMap<CharSequence, Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response>>();
    protected final ExecutorService pool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).build());
    private final File root;

    public FileNanoHTTPD(File root, int port) {
        super(port);
        this.root = root;
    }

    @Nonnull
    public static OutputStream create(int port, @Nonnull File path, String mimeType) throws IOException {
        return new StreamNanoHTTPD((int)port, (String)mimeType, (File)path).init().dataReciever;
    }

    public static Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response> handler(ExecutorService pool, String mimeType, @Nonnull Consumer<OutputStream> logic) {
        return session -> {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                logic.accept(out);
                out.flush();
                byte[] bytes = out.toByteArray();
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mimeType, (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length);
                return response;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        };
    }

    public Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response> addSessionHandler(CharSequence path, Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response> value) {
        return this.handlers.put(path, value);
    }

    public void addHandler(CharSequence path, String mimeType, @Nonnull Consumer<OutputStream> logic) {
        this.addSessionHandler(path, FileNanoHTTPD.handler(this.pool, mimeType, logic));
    }

    @Nonnull
    public FileNanoHTTPD init() throws IOException {
        this.start(30000);
        return this;
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        String requestPath = session.getUri();
        while (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        if (this.handlers.containsKey(requestPath)) {
            try {
                return this.handlers.get(requestPath).apply(session);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        File file = new File(this.root, requestPath);
        if (null != file && file.exists() && file.isFile()) {
            try {
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, null, (InputStream)new FileInputStream(file), (long)file.length());
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)"Not Found");
    }
}

