/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.simiacryptus.util.FileNanoHTTPD;
import com.simiacryptus.util.lang.UncheckedSupplier;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface NotebookOutput
extends Closeable {
    public static Consumer<NotebookOutput> concat(@Nonnull Consumer<NotebookOutput> fn, @Nonnull Consumer<NotebookOutput> header) {
        return log -> {
            header.accept((NotebookOutput)log);
            fn.accept((NotebookOutput)log);
        };
    }

    default public void code(@Nonnull Runnable fn) {
        this.code(() -> {
            fn.run();
            return null;
        }, this.getMaxOutSize(), 3);
    }

    default public <T> T code(UncheckedSupplier<T> fn) {
        return this.code(fn, this.getMaxOutSize(), 3);
    }

    default public <T> T out(UncheckedSupplier<T> fn) {
        return this.code(fn, Integer.MAX_VALUE, 3);
    }

    public <T> T code(UncheckedSupplier<T> var1, int var2, int var3);

    @Nonnull
    public OutputStream file(CharSequence var1);

    @Nonnull
    public String file(CharSequence var1, CharSequence var2);

    @Nonnull
    public CharSequence file(byte[] var1, CharSequence var2, CharSequence var3);

    @Nonnull
    public String file(CharSequence var1, CharSequence var2, CharSequence var3);

    public void h1(CharSequence var1, Object ... var2);

    public void h2(CharSequence var1, Object ... var2);

    public void h3(CharSequence var1, Object ... var2);

    @Nonnull
    public String image(BufferedImage var1, CharSequence var2);

    public CharSequence link(File var1, CharSequence var2);

    default public void out(String fmt, Object ... args) {
        this.p(fmt, args);
    }

    public void p(CharSequence var1, Object ... var2);

    default public void setFrontMatterProperty(CharSequence key, CharSequence value) {
    }

    default public void appendFrontMatterProperty(CharSequence key, CharSequence value, CharSequence delimiter) {
        CharSequence prior = this.getFrontMatterProperty(key);
        if (null == prior) {
            this.setFrontMatterProperty(key, value);
        } else {
            this.setFrontMatterProperty(key, prior.toString() + delimiter + value);
        }
    }

    @Nullable
    public CharSequence getFrontMatterProperty(CharSequence var1);

    public CharSequence getName();

    @Nonnull
    public File getResourceDir();

    public int getMaxOutSize();

    public FileNanoHTTPD getHttpd();
}

