/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.simiacryptus.util.FileNanoHTTPD;
import com.simiacryptus.util.io.AsyncOutputStream;
import com.simiacryptus.util.io.TeeOutputStream;
import fi.iki.elonen.NanoHTTPD;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class StreamNanoHTTPD
extends FileNanoHTTPD {
    @Nonnull
    public final TeeOutputStream dataReciever;
    @Nonnull
    protected final URI gatewayUri;
    @Nonnull
    private final File primaryFile;
    private final String mimeType;
    private boolean autobrowse = true;

    public StreamNanoHTTPD(int port, String mimeType, File primaryFile) throws IOException {
        super(primaryFile.getParentFile(), port);
        try {
            this.gatewayUri = null == primaryFile ? null : new URI(String.format("http://localhost:%s/%s", port, primaryFile.getName()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.primaryFile = primaryFile;
        this.mimeType = mimeType;
        this.dataReciever = null == primaryFile ? null : new TeeOutputStream((OutputStream)new FileOutputStream(primaryFile), true){

            @Override
            public void close() {
                try {
                    Thread.sleep(100L);
                    StreamNanoHTTPD.this.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    @Override
    @Nonnull
    public StreamNanoHTTPD init() throws IOException {
        super.init();
        if (!GraphicsEnvironment.isHeadless() && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            new Thread(() -> {
                try {
                    Thread.sleep(100L);
                    if (null != this.gatewayUri && this.isAutobrowse()) {
                        Desktop.getDesktop().browse(this.gatewayUri);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        }
        return this;
    }

    public StreamNanoHTTPD(int port) throws IOException {
        this(port, null, null);
    }

    public static Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response> asyncHandler(@Nonnull ExecutorService pool, String mimeType, @Nonnull Consumer<OutputStream> logic, boolean async) {
        return session -> {
            PipedInputStream snk = new PipedInputStream();
            Semaphore onComplete = new Semaphore(0);
            pool.submit(() -> {
                try (BufferedOutputStream out = new BufferedOutputStream(new AsyncOutputStream(new PipedOutputStream(snk)));){
                    try {
                        logic.accept(out);
                    }
                    finally {
                        onComplete.release();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            });
            if (!async) {
                try {
                    onComplete.acquire();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return NanoHTTPD.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mimeType, (InputStream)new BufferedInputStream(snk));
        };
    }

    public void addAsyncHandler(CharSequence path, String mimeType, @Nonnull Consumer<OutputStream> logic, boolean async) {
        this.addSessionHandler(path, StreamNanoHTTPD.asyncHandler(this.pool, mimeType, logic, async));
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        String requestPath = session.getUri();
        while (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        if (null != this.primaryFile && requestPath.equals(this.primaryFile.getName())) {
            try {
                NanoHTTPD.Response response = NanoHTTPD.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)this.mimeType, (InputStream)new BufferedInputStream(this.dataReciever.newInputStream()));
                response.setGzipEncoding(false);
                return response;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return super.serve(session);
    }

    protected boolean useGzipWhenAccepted(NanoHTTPD.Response r) {
        return false;
    }

    public boolean isAutobrowse() {
        return this.autobrowse;
    }

    public StreamNanoHTTPD setAutobrowse(boolean autobrowse) {
        this.autobrowse = autobrowse;
        return this;
    }
}

