/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.simiacryptus.util.io.AsyncListIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public abstract class DataLoader<T> {
    private final List<T> queue = Collections.synchronizedList(new ArrayList());
    @Nullable
    private volatile Thread thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws InterruptedException {
        if (this.thread != null) {
            DataLoader dataLoader = this;
            synchronized (dataLoader) {
                if (this.thread != null) {
                    this.thread.interrupt();
                    this.thread.join();
                    this.thread = null;
                    this.queue.clear();
                }
            }
        }
    }

    protected abstract void read(List<T> var1);

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<T> stream() {
        if (this.thread == null) {
            DataLoader dataLoader = this;
            synchronized (dataLoader) {
                if (this.thread == null) {
                    this.thread = new Thread(() -> this.read(this.queue));
                    this.thread.setDaemon(true);
                    this.thread.start();
                }
            }
        }
        AsyncListIterator<T> iterator = new AsyncListIterator<T>(this.queue, this.thread);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1), false).filter(x -> x != null);
    }
}

