/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeUtil {
    private static final Logger logger = LoggerFactory.getLogger(CodeUtil.class);
    private static final List<CharSequence> sourceFolders = Arrays.asList("src/main/java", "src/test/java", "src/main/scala", "src/test/scala");
    @Nonnull
    public static File projectRoot = new File(System.getProperty("codeRoot", ".."));
    private static final List<File> codeRoots = CodeUtil.loadCodeRoots();

    @Nullable
    public static File findFile(@Nullable Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        String name = clazz.getName();
        if (null == name) {
            return null;
        }
        String path = name.replaceAll("\\.", "/").replaceAll("\\$.*", "");
        return CodeUtil.findFile(path + ".java");
    }

    @Nonnull
    public static File findFile(@Nonnull StackTraceElement callingFrame) {
        String[] packagePath = callingFrame.getClassName().split("\\.");
        String path = Arrays.stream(packagePath).limit(packagePath.length - 1).collect(Collectors.joining(File.separator)) + File.separator + callingFrame.getFileName();
        return CodeUtil.findFile(path);
    }

    @Nonnull
    public static File findFile(@Nonnull String path) {
        for (File root : codeRoots) {
            File file = new File(root, path);
            if (!file.exists()) continue;
            return file;
        }
        throw new RuntimeException(String.format("Not Found: %s; Project Roots = %s", path, codeRoots));
    }

    @Nonnull
    public static CharSequence getIndent(@Nonnull CharSequence txt) {
        Matcher matcher = Pattern.compile("^\\s+").matcher(txt);
        return matcher.find() ? matcher.group(0) : "";
    }

    public static String getInnerText(@Nonnull StackTraceElement callingFrame) {
        String[] split = callingFrame.getClassName().split("\\.");
        String fileResource = Arrays.stream(split).limit(split.length - 1).reduce((a, b) -> a + "/" + b).get() + "/" + callingFrame.getFileName();
        InputStream resourceAsStream = CodeUtil.class.getClassLoader().getResourceAsStream(fileResource);
        try {
            List<String> allLines = null;
            if (null != resourceAsStream) {
                try {
                    allLines = IOUtils.readLines((InputStream)resourceAsStream, (String)"UTF-8");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (null == allLines) {
                File file = CodeUtil.findFile(callingFrame);
                assert (null != file);
                allLines = Files.readAllLines(file.toPath());
            }
            int start = callingFrame.getLineNumber() - 1;
            CharSequence txt = (CharSequence)allLines.get(start);
            CharSequence indent = CodeUtil.getIndent(txt);
            ArrayList<String> lines = new ArrayList<String>();
            for (int i = start + 1; i < allLines.size() && (CodeUtil.getIndent(allLines.get(i)).length() > indent.length() || String.valueOf(allLines.get(i)).trim().isEmpty()); ++i) {
                String line = allLines.get(i);
                lines.add(line.substring(Math.min(indent.length(), line.length())));
            }
            return lines.stream().collect(Collectors.joining("\n"));
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String getJavadoc(@Nullable Class<?> clazz) {
        try {
            if (null == clazz) {
                return null;
            }
            File source = CodeUtil.findFile(clazz);
            if (null == source) {
                return clazz.getName() + " not found";
            }
            List lines = IOUtils.readLines((InputStream)new FileInputStream(source), (Charset)Charset.forName("UTF-8"));
            int classDeclarationLine = IntStream.range(0, lines.size()).filter(i -> ((String)lines.get(i)).contains("class " + clazz.getSimpleName())).findFirst().getAsInt();
            int firstLine = IntStream.rangeClosed(1, classDeclarationLine).map(i -> classDeclarationLine - i).filter(i -> !((String)lines.get(i)).matches("\\s*[/\\*@].*")).findFirst().orElse(-1) + 1;
            String javadoc = lines.subList(firstLine, classDeclarationLine).stream().filter(s -> s.matches("\\s*[/\\*].*")).map(s -> s.replaceFirst("^[ \t]*[/\\*]+", "").trim()).filter(x -> !x.isEmpty()).reduce((a, b) -> a + "\n" + b).orElse("");
            return javadoc.replaceAll("<p>", "\n");
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    private static List<File> loadCodeRoots() {
        return Stream.concat(Stream.of(projectRoot), Arrays.stream(projectRoot.listFiles()).filter(file -> file.exists() && file.isDirectory()).collect(Collectors.toList()).stream()).flatMap(x -> CodeUtil.scanProject(x).stream()).distinct().collect(Collectors.toList());
    }

    private static List<File> scanProject(File file) {
        return sourceFolders.stream().map(name -> new File(file, name.toString())).filter(f -> f.exists() && f.isDirectory()).collect(Collectors.toList());
    }

    @Nonnull
    public static String getGitBase() {
        File absoluteFile = new File(".").getAbsoluteFile();
        try {
            Repository repository = ((RepositoryBuilder)new RepositoryBuilder().setWorkTree(absoluteFile)).build();
            StoredConfig config = repository.getConfig();
            String head = repository.resolve("HEAD").toObjectId().getName();
            String remoteUrl = config.getString("remote", "origin", "url");
            Pattern githubPattern = Pattern.compile("git@github.com:([^/]+)/([^/]+).git");
            Matcher matcher = githubPattern.matcher(remoteUrl);
            if (matcher.matches()) {
                return "https://github.com/" + matcher.group(1) + "/" + matcher.group(2) + "/tree/" + head + "/";
            }
        }
        catch (Throwable e) {
            logger.debug("Error querying local git config for " + absoluteFile, e);
        }
        return System.getProperty("GITBASE", "https://github.com/SimiaCryptus/mindseye-art/tree/master/");
    }
}

