/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.simiacryptus.util.io.JsonUtil;
import de.javakaffee.kryoserializers.KryoReflectionFactorySupport;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;

public class IOUtil {
    private static final ObjectMapper objectMapper = JsonUtil.getMapper();
    private static final ThreadLocal<Kryo> kryo = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            return kryo;
        }
    };
    private static final ThreadLocal<byte[]> buffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[0x800000];
        }
    };

    public static <T> void writeJson(T obj, File file) {
        StringWriter writer = new StringWriter();
        try {
            objectMapper.writeValue((Writer)writer, obj);
            Files.write(file.toPath(), writer.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readJson(File file) {
        try {
            return (T)objectMapper.readValue(new String(Files.readAllBytes(file.toPath())), new TypeReference<T>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void writeKryo(T obj, OutputStream file) {
        try {
            Output output = new Output(buffer.get());
            new KryoReflectionFactorySupport().writeClassAndObject(output, obj);
            output.close();
            IOUtils.write((byte[])Arrays.copyOf(output.getBuffer(), output.position()), (OutputStream)file);
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeString(String obj, OutputStream file) {
        try {
            IOUtils.write((byte[])obj.getBytes("UTF-8"), (OutputStream)file);
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readKryo(File file) {
        try {
            byte[] bytes = Files.readAllBytes(file.toPath());
            Input input = new Input(buffer.get(), 0, bytes.length);
            return (T)new KryoReflectionFactorySupport().readClassAndObject(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

