/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.simiacryptus.util.FileNanoHTTPD;
import com.simiacryptus.util.TableOutput;
import com.simiacryptus.util.Util;
import com.simiacryptus.util.io.NotebookOutput;
import com.simiacryptus.util.lang.CodeUtil;
import com.simiacryptus.util.lang.TimedResult;
import com.simiacryptus.util.lang.UncheckedSupplier;
import com.simiacryptus.util.test.SysOutInterceptor;
import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacterExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.SubscriptExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.pdf.converter.PdfConverterExtension;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownNotebookOutput
implements NotebookOutput {
    static final Logger log = LoggerFactory.getLogger(MarkdownNotebookOutput.class);
    public static int MAX_OUTPUT = 4096;
    private static int excerptNumber = 0;
    private static int imageNumber = 0;
    @Nonnull
    private final File reportFile;
    private final String name;
    @Nonnull
    private final PrintStream primaryOut;
    private final List<CharSequence> markdownData = new ArrayList<CharSequence>();
    private final List<Consumer<File>> onComplete = new ArrayList<Consumer<File>>();
    private final Map<CharSequence, CharSequence> frontMatter = new HashMap<CharSequence, CharSequence>();
    private final FileNanoHTTPD httpd;
    private final boolean autobrowse;
    private int maxImageSize = 1600;
    @Nonnull
    public List<CharSequence> toc = new ArrayList<CharSequence>();
    int anchor = 0;
    @Nullable
    private final String baseCodeUrl = CodeUtil.getGitBase();

    public MarkdownNotebookOutput(@Nonnull File reportFile, String name, boolean autobrowse) throws FileNotFoundException {
        this(reportFile, name, new Random().nextInt(2048) + 2048, autobrowse);
    }

    public MarkdownNotebookOutput(@Nonnull File reportFile, String name, int httpPort, boolean autobrowse) throws FileNotFoundException {
        this.name = name;
        reportFile.getAbsoluteFile().getParentFile().mkdirs();
        this.primaryOut = new PrintStream(new FileOutputStream(reportFile));
        this.reportFile = reportFile;
        this.httpd = new FileNanoHTTPD(reportFile.getParentFile(), httpPort);
        this.httpd.addHandler("", "text/html", out -> {
            try {
                this.writeHtmlAndPdf(this.getRoot(), this.testName());
                try (FileInputStream input = new FileInputStream(new File(this.getRoot(), this.testName() + ".html"));){
                    IOUtils.copy((InputStream)input, (OutputStream)out);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        this.httpd.addHandler("pdf", "application/pdf", out -> {
            try {
                this.writeHtmlAndPdf(this.getRoot(), this.testName());
                try (FileInputStream input = new FileInputStream(new File(this.getRoot(), this.testName() + ".pdf"));){
                    IOUtils.copy((InputStream)input, (OutputStream)out);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        this.autobrowse = autobrowse;
        try {
            log.info("Starting server at port " + httpPort);
            this.httpd.init();
            if (!GraphicsEnvironment.isHeadless() && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                new Thread(() -> {
                    try {
                        while (!this.httpd.isAlive()) {
                            Thread.sleep(100L);
                        }
                        if (this.isAutobrowse()) {
                            Desktop.getDesktop().browse(new URI(String.format("http://localhost:%d", httpPort)));
                        }
                    }
                    catch (IOException | InterruptedException | URISyntaxException e) {
                        e.printStackTrace();
                    }
                }).start();
                this.onComplete(file -> {
                    try {
                        if (this.isAutobrowse()) {
                            Desktop.getDesktop().browse(new File((File)file, this.testName() + ".html").toURI());
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            this.onComplete(file -> this.httpd.stop());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Consumer<NotebookOutput> wrapFrontmatter(@Nonnull Consumer<NotebookOutput> fn) {
        return log -> {
            TimedResult<Void> time = TimedResult.time(() -> {
                try {
                    fn.accept((NotebookOutput)log);
                    log.setFrontMatterProperty("result", "OK");
                }
                catch (Throwable e) {
                    log.setFrontMatterProperty("result", MarkdownNotebookOutput.getExceptionString(e).toString().replaceAll("\n", "<br/>").trim());
                    throw (RuntimeException)(e instanceof RuntimeException ? e : new RuntimeException(e));
                }
            });
            log.setFrontMatterProperty("execution_time", String.format("%.6f", (double)time.timeNanos / 1.0E9));
        };
    }

    public static MarkdownNotebookOutput get(boolean autobrowse) {
        try {
            StackTraceElement callingFrame = Thread.currentThread().getStackTrace()[2];
            String className = callingFrame.getClassName();
            String methodName = callingFrame.getMethodName();
            String fileName = methodName + ".md";
            File path = new File(Util.mkString(File.separator, "reports", className.replaceAll("\\.", "/").replaceAll("\\$", "/")));
            path = new File(path, fileName);
            path.getParentFile().mkdirs();
            return new MarkdownNotebookOutput(path, methodName, autobrowse);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static MarkdownNotebookOutput get(Object source, boolean autobrowse) {
        try {
            StackTraceElement callingFrame = Thread.currentThread().getStackTrace()[2];
            String className = null == source ? callingFrame.getClassName() : source.getClass().getCanonicalName();
            String methodName = callingFrame.getMethodName();
            String fileName = methodName + ".md";
            File path = new File(Util.mkString(File.separator, "reports", className.replaceAll("\\.", "/").replaceAll("\\$", "/"), fileName));
            path.getParentFile().mkdirs();
            return new MarkdownNotebookOutput(path, methodName, autobrowse);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static CharSequence getExceptionString(Throwable e) {
        if (e instanceof RuntimeException && e.getCause() != null && e.getCause() != e) {
            return MarkdownNotebookOutput.getExceptionString(e.getCause());
        }
        if (e.getCause() != null && e.getCause() != e) {
            return e.getClass().getSimpleName() + " / " + MarkdownNotebookOutput.getExceptionString(e.getCause());
        }
        return e.getClass().getSimpleName();
    }

    @Nonnull
    public MarkdownNotebookOutput onComplete(Consumer<File> ... tasks) {
        Arrays.stream(tasks).forEach(this.onComplete::add);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (null != this.primaryOut) {
            this.primaryOut.close();
        }
        try (PrintWriter out = new PrintWriter(new FileOutputStream(this.reportFile));){
            this.writeMarkdownWithFrontmatter(out);
        }
        File root = this.getRoot();
        this.writeHtmlAndPdf(root, this.testName());
        this.writeZip(root, this.testName());
        this.onComplete.stream().forEach(fn -> {
            try {
                fn.accept(root);
            }
            catch (Throwable e) {
                log.info("Error closing log", e);
            }
        });
    }

    @Nonnull
    public File getRoot() {
        return new File(this.reportFile.getParent());
    }

    public String testName() {
        String[] split = this.reportFile.getName().split(".");
        return 0 == split.length ? this.reportFile.getName() : split[0];
    }

    public void writeZip(File root, String baseName) throws IOException {
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(new File(root, baseName + ".zip")));){
            this.writeArchive(root, root, out, file -> !file.getName().equals(baseName + ".zip") && !file.getName().equals(baseName + ".pdf"));
        }
    }

    public static Path pathToCodeFile(File baseFile, @Nonnull File file) throws IOException {
        return baseFile.getCanonicalFile().toPath().relativize(file.getCanonicalFile().toPath());
    }

    @Nonnull
    public String toString(List<CharSequence> list) {
        if (list.size() > 0 && list.stream().allMatch(x -> {
            if (x.length() > 1) {
                char c = x.charAt(0);
                return c == ' ' || c == '\t';
            }
            return false;
        })) {
            return this.toString(list.stream().map(x -> x.subSequence(1, x.length()).toString()).collect(Collectors.toList()));
        }
        return ((CharSequence)list.stream().reduce((a, b) -> a + "\n" + b).orElse("")).toString();
    }

    public void writeArchive(File root, File dir, ZipOutputStream out, Predicate<? super File> filter) {
        Arrays.stream(dir.listFiles()).filter(filter).forEach(file -> {
            if (file.isDirectory()) {
                this.writeArchive(root, (File)file, out, filter);
            } else {
                String absRoot = root.getAbsolutePath();
                String absFile = file.getAbsolutePath();
                String relativeFile = absFile.substring(absRoot.length());
                if (relativeFile.startsWith(File.separator)) {
                    relativeFile = relativeFile.substring(1);
                }
                try {
                    out.putNextEntry(new ZipEntry(relativeFile));
                    IOUtils.copy((InputStream)new FileInputStream((File)file), (OutputStream)out);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void writeMarkdownWithFrontmatter(PrintWriter out) {
        if (!this.frontMatter.isEmpty()) {
            out.println("---");
            this.frontMatter.forEach((key, value) -> {
                String escaped = StringEscapeUtils.escapeJson((String)String.valueOf(value)).replaceAll("\n", " ").replaceAll(":", "&#58;").replaceAll("\\{", "\\{").replaceAll("\\}", "\\}");
                out.println(String.format("%s: %s", key, escaped));
            });
            out.println("---");
        }
        this.toc.forEach(out::println);
        out.print("\n\n");
        this.markdownData.forEach(out::println);
    }

    @Override
    public void setFrontMatterProperty(CharSequence key, CharSequence value) {
        this.frontMatter.put(key, value);
    }

    @Override
    public CharSequence getFrontMatterProperty(CharSequence key) {
        return this.frontMatter.get(key);
    }

    @Override
    public CharSequence getName() {
        return this.name;
    }

    public CharSequence anchor(CharSequence anchorId) {
        return String.format("<a id=\"%s\"></a>", anchorId);
    }

    public CharSequence anchorId() {
        return String.format("p-%d", this.anchor++);
    }

    public void writeHtmlAndPdf(File root, String baseName) throws IOException {
        MutableDataSet options = new MutableDataSet();
        List<Extension> extensions = Arrays.asList(TablesExtension.create(), SubscriptExtension.create(), EscapedCharacterExtension.create());
        Parser parser = Parser.builder((DataHolder)options).extensions(extensions).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).extensions(extensions).escapeHtml(false).indentSize(2).softBreak("\n").build();
        File htmlFile = new File(root, baseName + ".html");
        String html = renderer.render((Node)parser.parse(this.toString(this.toc) + "\n\n" + this.toString(this.markdownData)));
        html = "<html><body>" + html + "</body></html>";
        try (FileOutputStream out = new FileOutputStream(htmlFile);){
            IOUtils.write((String)html, (OutputStream)out, (Charset)Charset.forName("UTF-8"));
        }
        out = new FileOutputStream(new File(root, baseName + ".pdf"));
        var10_10 = null;
        try {
            PdfConverterExtension.exportToPdf((OutputStream)out, (String)html, (String)htmlFile.getAbsoluteFile().toURI().toString(), (DataHolder)options);
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var10_10 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
    }

    @Override
    @Nonnull
    public OutputStream file(@Nonnull CharSequence name) {
        try {
            return new FileOutputStream(new File(this.getResourceDir(), name.toString()));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public String file(CharSequence data, CharSequence caption) {
        return this.file(data, (CharSequence)(++excerptNumber + ".txt"), caption);
    }

    @Override
    @Nonnull
    public CharSequence file(@Nonnull byte[] data, @Nonnull CharSequence filename, CharSequence caption) {
        return this.file(new String(data, Charset.forName("UTF-8")), filename, caption);
    }

    @Override
    @Nonnull
    public String file(@Nullable CharSequence data, @Nonnull CharSequence fileName, CharSequence caption) {
        try {
            if (null != data) {
                IOUtils.write((CharSequence)data, (OutputStream)new FileOutputStream(new File(this.getResourceDir(), fileName.toString())), (Charset)Charset.forName("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "[" + caption + "](etc/" + fileName + ")";
    }

    @Override
    @Nonnull
    public File getResourceDir() {
        File etc = new File(this.reportFile.getParentFile(), "etc").getAbsoluteFile();
        etc.mkdirs();
        return etc;
    }

    @Override
    public void h1(@Nonnull CharSequence fmt, Object ... args) {
        CharSequence anchorId = this.anchorId();
        String msg = this.format(fmt, args);
        this.toc.add(String.format("1. [%s](#%s)", msg, anchorId));
        this.out("# " + this.anchor(anchorId) + msg, new Object[0]);
    }

    @Override
    public void h2(@Nonnull CharSequence fmt, Object ... args) {
        CharSequence anchorId = this.anchorId();
        String msg = this.format(fmt, args);
        this.toc.add(String.format("   1. [%s](#%s)", msg, anchorId));
        this.out("## " + this.anchor(anchorId) + fmt, args);
    }

    @Override
    public void h3(@Nonnull CharSequence fmt, Object ... args) {
        CharSequence anchorId = this.anchorId();
        String msg = this.format(fmt, args);
        this.toc.add(String.format("      1. [%s](#%s)", msg, anchorId));
        this.out("### " + this.anchor(anchorId) + fmt, args);
    }

    @Override
    @Nonnull
    public String image(@Nullable BufferedImage rawImage, CharSequence caption) {
        if (null == rawImage) {
            return "";
        }
        new ByteArrayOutputStream();
        int thisImage = ++imageNumber;
        String fileName = this.name + "." + thisImage + ".png";
        File file = new File(this.getResourceDir(), fileName);
        BufferedImage stdImage = Util.maximumSize(rawImage, this.getMaxImageSize());
        try {
            if (stdImage != rawImage) {
                String rawName = this.name + "_raw." + thisImage + ".png";
                ImageIO.write((RenderedImage)rawImage, "png", new File(this.getResourceDir(), rawName));
            }
            ImageIO.write((RenderedImage)stdImage, "png", file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.anchor(this.anchorId()) + "![" + caption + "](etc/" + file.getName() + ")";
    }

    @Override
    public <T> T code(@Nonnull UncheckedSupplier<T> fn, int maxLog, int framesNo) {
        try {
            CharSequence codeLink;
            StackTraceElement callingFrame = Thread.currentThread().getStackTrace()[framesNo];
            String sourceCode = CodeUtil.getInnerText(callingFrame);
            SysOutInterceptor.LoggedResult<TimedResult> result = SysOutInterceptor.withOutput(() -> {
                long priorGcMs = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum();
                long start = System.nanoTime();
                try {
                    Object result1 = null;
                    try {
                        result1 = fn.get();
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    long gcTime = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum() - priorGcMs;
                    return new TimedResult<Object>(result1, System.nanoTime() - start, gcTime);
                }
                catch (Throwable e) {
                    long gcTime = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum() - priorGcMs;
                    return new TimedResult<Throwable>(e, System.nanoTime() - start, gcTime);
                }
            });
            try {
                codeLink = this.pathToGitResource(CodeUtil.findFile(callingFrame));
            }
            catch (Throwable e) {
                String[] split = callingFrame.getClassName().split("\\.");
                String packagePath = (String)Arrays.asList(split).subList(0, split.length - 1).stream().reduce((a, b) -> a + "/" + b).get();
                codeLink = this.baseCodeUrl + "/src/main/java/" + packagePath + "/" + callingFrame.getFileName();
            }
            this.out(this.anchor(this.anchorId()) + "Code from [%s:%s](%s#L%s) executed in %.2f seconds (%.3f gc): ", callingFrame.getFileName(), callingFrame.getLineNumber(), codeLink, callingFrame.getLineNumber(), ((TimedResult)result.obj).seconds(), ((TimedResult)result.obj).gc_seconds());
            String text = sourceCode.replaceAll("\n", "\n  ");
            this.out("```java", new Object[0]);
            this.out("  " + text, new Object[0]);
            this.out("```", new Object[0]);
            if (!result.log.isEmpty()) {
                String summary = this.summarize(result.log, maxLog).replaceAll("\n", "\n    ").replaceAll("    ~", "");
                this.out(this.anchor(this.anchorId()) + "Logging: ", new Object[0]);
                this.out("```", new Object[0]);
                this.out("    " + summary, new Object[0]);
                this.out("```", new Object[0]);
            }
            this.out("", new Object[0]);
            Object eval = ((TimedResult)result.obj).result;
            if (null != eval) {
                String fmt;
                boolean escape;
                String str;
                this.out(this.anchor(this.anchorId()) + "Returns: \n", new Object[0]);
                if (eval instanceof Throwable) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ((Throwable)eval).printStackTrace(new PrintStream(out));
                    str = new String(out.toByteArray(), "UTF-8");
                    escape = true;
                } else if (eval instanceof Component) {
                    str = this.image(Util.toImage((Component)eval), "Result");
                    escape = false;
                } else if (eval instanceof BufferedImage) {
                    str = this.image((BufferedImage)eval, "Result");
                    escape = false;
                } else if (eval instanceof TableOutput) {
                    str = ((TableOutput)eval).toMarkdownTable();
                    escape = false;
                } else {
                    str = eval.toString();
                    escape = true;
                }
                String string = fmt = escape ? "    " + this.summarize(str, maxLog).replaceAll("\n", "\n    ").replaceAll("    ~", "") : str;
                if (escape) {
                    this.out("```", new Object[0]);
                    this.out(fmt, new Object[0]);
                    this.out("```", new Object[0]);
                } else {
                    this.out(fmt, new Object[0]);
                }
                this.out("\n\n", new Object[0]);
                if (eval instanceof RuntimeException) {
                    throw (RuntimeException)((TimedResult)result.obj).result;
                }
                if (eval instanceof Throwable) {
                    throw new RuntimeException((Throwable)((TimedResult)result.obj).result);
                }
            }
            return eval;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public CharSequence link(@Nonnull File file, CharSequence text) {
        try {
            return "[" + text + "](" + this.pathToReportResource(file) + ")";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CharSequence pathToReportResource(@Nonnull File file) throws IOException {
        Path path = MarkdownNotebookOutput.pathToCodeFile(this.reportFile, file);
        String pathSlash = path.normalize().toString().replaceAll("\\\\", "/");
        return pathSlash;
    }

    public CharSequence pathToGitResource(@Nonnull File file) throws IOException {
        Path path = MarkdownNotebookOutput.pathToCodeFile(new File("."), file);
        String pathSlash = path.normalize().toString().replaceAll("\\\\", "/");
        if (null != this.baseCodeUrl) {
            try {
                URI resolve = new URI(this.baseCodeUrl).resolve(pathSlash);
                return resolve.normalize().toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return pathSlash;
    }

    @Override
    public void out(@Nonnull String fmt, Object ... args) {
        String msg = this.format(fmt, args);
        this.markdownData.add(msg);
        this.primaryOut.println(msg);
        log.info(msg);
    }

    @Nonnull
    public String format(@Nonnull CharSequence fmt, Object ... args) {
        return 0 == args.length ? fmt.toString() : String.format(fmt.toString(), args);
    }

    @Override
    public void p(CharSequence fmt, Object ... args) {
        this.out(this.anchor(this.anchorId()).toString() + fmt + "\n", args);
    }

    @Nonnull
    public String summarize(@Nonnull String logSrc, int maxLog) {
        if (logSrc.length() > maxLog * 2) {
            String prefix = logSrc.substring(0, maxLog);
            logSrc = prefix + String.format((prefix.endsWith("\n") ? "" : "\n") + "~```\n~..." + this.file(logSrc, "skipping %s bytes") + "...\n~```\n", logSrc.length() - 2 * maxLog) + logSrc.substring(logSrc.length() - maxLog);
        }
        return logSrc;
    }

    @Override
    public int getMaxOutSize() {
        return MAX_OUTPUT;
    }

    @Override
    public FileNanoHTTPD getHttpd() {
        return this.httpd;
    }

    public boolean isAutobrowse() {
        return this.autobrowse;
    }

    public int getMaxImageSize() {
        return this.maxImageSize;
    }

    public MarkdownNotebookOutput setMaxImageSize(int maxImageSize) {
        this.maxImageSize = maxImageSize;
        return this;
    }
}

