/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.simiacryptus.util.io.FairAsyncWorkQueue;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class AsyncOutputStream
extends FilterOutputStream {
    private final FairAsyncWorkQueue queue = new FairAsyncWorkQueue();

    public AsyncOutputStream(@Nonnull OutputStream stream) {
        super(stream);
    }

    @Override
    public synchronized void close() {
        this.queue.submit(() -> {
            try {
                this.out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public synchronized void flush() {
        this.queue.submit(() -> {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        byte[] _b = Arrays.copyOfRange(b, off, Math.min(b.length, off + len));
        this.queue.submit(() -> {
            try {
                this.out.write(_b);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.queue.submit(() -> {
            try {
                this.out.write(b);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

