/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.notebook;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.simiacryptus.notebook.FileHTTPD;
import com.simiacryptus.notebook.NanoHTTPD;
import com.simiacryptus.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNanoHTTPD
extends NanoHTTPD
implements FileHTTPD {
    static final Logger log = LoggerFactory.getLogger(FileNanoHTTPD.class);
    public final Map<CharSequence, Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response>> getHandlers = new HashMap<CharSequence, Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response>>();
    public final Map<CharSequence, Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response>> postHandlers = new HashMap<CharSequence, Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response>>();
    protected final ExecutorService pool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).build());
    private final File root;

    public FileNanoHTTPD(File root, int port) {
        super(port);
        this.root = root;
    }

    @Nonnull
    public static FileNanoHTTPD create(int port, @Nonnull File path, String mimeType) throws IOException {
        return new FileNanoHTTPD(path, port).init();
    }

    public static Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response> handler(String mimeType, @Nonnull Consumer<OutputStream> logic) {
        return session -> {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                logic.accept(out);
                out.flush();
                byte[] bytes = out.toByteArray();
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, mimeType, new ByteArrayInputStream(bytes), bytes.length);
                return response;
            }
            catch (Throwable e) {
                log.warn("Error handling httprequest", e);
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public Closeable addGET(CharSequence path, Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response> value) {
        Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response> put = this.getHandlers.put(path, value);
        return () -> this.getHandlers.remove(path, put);
    }

    @Override
    public Closeable addPOST(CharSequence path, Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response> value) {
        Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response> put = this.postHandlers.put(path, value);
        return () -> this.postHandlers.remove(path, put);
    }

    @Override
    public Closeable addGET(CharSequence path, String mimeType, @Nonnull Consumer<OutputStream> logic) {
        return this.addGET(path, FileNanoHTTPD.handler(mimeType, logic));
    }

    @Nonnull
    public FileNanoHTTPD init() throws IOException {
        this.start(30000);
        return this;
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        String requestPath = Util.stripPrefix(session.getUri(), "/");
        File file = new File(this.root, requestPath);
        if (session.getMethod() == NanoHTTPD.Method.GET) {
            Comparator<Map.Entry> objectComparator = Comparator.comparing(x -> ((CharSequence)x.getKey()).length());
            Optional<Function> handler = this.getHandlers.entrySet().stream().filter(e -> {
                String prefix = ((CharSequence)e.getKey()).toString();
                if (prefix.isEmpty() && requestPath.isEmpty()) {
                    return true;
                }
                if (prefix.isEmpty() || requestPath.isEmpty()) {
                    return false;
                }
                return requestPath.startsWith(prefix);
            }).sorted(objectComparator.reversed()).findFirst().map(e -> (Function)e.getValue());
            handler.orElse(null);
            if (handler.isPresent()) {
                try {
                    return (NanoHTTPD.Response)handler.get().apply(session);
                }
                catch (Throwable e2) {
                    log.warn("Error requesting " + session.getUri(), e2);
                    throw new RuntimeException(e2);
                }
            }
            if (null != file && file.exists() && file.isFile()) {
                try {
                    return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, null, new FileInputStream(file), file.length());
                }
                catch (FileNotFoundException e3) {
                    throw new RuntimeException(e3);
                }
            }
            log.warn(String.format("Not Found: %s\n\tCurrent Path: %s\n\t%s", requestPath, this.root.getAbsolutePath(), this.getHandlers.keySet().stream().map(handlerPath -> "Installed Handler: " + handlerPath).reduce((a, b) -> a + "\n\t" + b).get()));
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/plain", "Not Found");
        }
        if (session.getMethod() == NanoHTTPD.Method.POST) {
            Optional<Function> handler = this.postHandlers.entrySet().stream().filter(e -> requestPath.startsWith(((CharSequence)e.getKey()).toString())).findAny().map(e -> (Function)e.getValue());
            handler.orElse(null);
            if (handler.isPresent()) {
                try {
                    return (NanoHTTPD.Response)handler.get().apply(session);
                }
                catch (Throwable e4) {
                    log.warn("Error requesting " + session.getUri(), e4);
                    throw new RuntimeException(e4);
                }
            }
            log.warn(String.format("Not Found: %s\n\tCurrent Path: %s\n\t%s", requestPath, this.root.getAbsolutePath(), this.getHandlers.keySet().stream().map(handlerPath -> "Installed Handler: " + handlerPath).reduce((a, b) -> a + "\n\t" + b).get()));
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/plain", "Not Found");
        }
        return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED, "test/plain", "Invalid Method");
    }
}

