/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.notebook;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.simiacryptus.notebook.MarkdownNotebookOutput;
import com.simiacryptus.notebook.StringQuery;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JsonQuery<T>
extends StringQuery<T> {
    private ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public JsonQuery(MarkdownNotebookOutput log) {
        super(log);
    }

    @Override
    protected T fromString(String text) throws IOException {
        return (T)this.mapper.readValue((InputStream)new ByteArrayInputStream(text.getBytes()), this.value.getClass());
    }

    @Override
    protected String getString(T value) throws JsonProcessingException {
        return this.mapper.writeValueAsString(value);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public JsonQuery<T> setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
        return this;
    }
}

