/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.notebook;

import com.simiacryptus.lang.TimedResult;
import com.simiacryptus.lang.UncheckedSupplier;
import com.simiacryptus.notebook.FileHTTPD;
import com.simiacryptus.notebook.FileNanoHTTPD;
import com.simiacryptus.notebook.NotebookOutput;
import com.simiacryptus.notebook.NullHTTPD;
import com.simiacryptus.notebook.TableOutput;
import com.simiacryptus.util.CodeUtil;
import com.simiacryptus.util.Util;
import com.simiacryptus.util.test.SysOutInterceptor;
import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacterExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.SubscriptExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.pdf.converter.PdfConverterExtension;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownNotebookOutput
implements NotebookOutput {
    private static final Logger logger = LoggerFactory.getLogger(MarkdownNotebookOutput.class);
    public static final Random random = new Random();
    static final Logger log = LoggerFactory.getLogger(MarkdownNotebookOutput.class);
    public static int MAX_OUTPUT = 1024;
    private static int excerptNumber = 0;
    private static int imageNumber = 0;
    @Nonnull
    private final File root;
    @Nonnull
    private final PrintStream primaryOut;
    private final List<CharSequence> markdownData = new ArrayList<CharSequence>();
    private final List<Runnable> onComplete = new ArrayList<Runnable>();
    private final Map<CharSequence, CharSequence> frontMatter = new HashMap<CharSequence, CharSequence>();
    private final FileNanoHTTPD httpd;
    @Nonnull
    public List<CharSequence> toc = new ArrayList<CharSequence>();
    int anchor = 0;
    private String name;
    private boolean autobrowse;
    private int maxImageSize = 1600;
    private URI currentHome = null;
    private URI archiveHome = null;

    public MarkdownNotebookOutput(@Nonnull File reportFile, boolean autobrowse) throws FileNotFoundException {
        this(reportFile, random.nextInt(2048) + 2048, autobrowse);
    }

    public MarkdownNotebookOutput(@Nonnull File reportFile) throws FileNotFoundException {
        this(reportFile, random.nextInt(2048) + 2048, true);
    }

    public MarkdownNotebookOutput(@Nonnull File reportFile, int httpPort, boolean autobrowse) throws FileNotFoundException {
        FileNanoHTTPD httpd;
        this.setName(reportFile.getName());
        this.root = reportFile.getAbsoluteFile().getParentFile();
        this.root.mkdirs();
        this.setCurrentHome(this.root.toURI());
        this.setArchiveHome(this.root.toURI());
        this.primaryOut = new PrintStream(new FileOutputStream(new File(this.root, this.getName().toString())));
        FileNanoHTTPD fileNanoHTTPD = httpd = httpPort <= 0 ? null : new FileNanoHTTPD(this.root, httpPort);
        if (null != httpd) {
            httpd.addGET("", "text/html", out -> {
                try {
                    this.write();
                    try (FileInputStream input = new FileInputStream(new File(this.getRoot(), this.getName() + ".html"));){
                        IOUtils.copy((InputStream)input, (OutputStream)out);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (null != httpd) {
            httpd.addGET("pdf", "application/pdf", out -> {
                try {
                    this.write();
                    try (FileInputStream input = new FileInputStream(new File(this.getRoot(), this.getName() + ".pdf"));){
                        IOUtils.copy((InputStream)input, (OutputStream)out);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (null != httpd) {
            httpd.addGET("shutdown", "text/plain", out -> {
                try (PrintStream printStream = new PrintStream((OutputStream)out);){
                    printStream.print("Closing...");
                    try {
                        this.close();
                        printStream.print("Done");
                    }
                    catch (IOException e) {
                        e.printStackTrace(printStream);
                    }
                }
                logger.warn("Exiting notebook", (Throwable)new RuntimeException("Stack Trace"));
                System.exit(0);
            });
        }
        this.setAutobrowse(autobrowse);
        log.info(String.format("Serving %s/%s at http://localhost:%d", this.root.getAbsoluteFile(), this.getName(), httpPort));
        if (null != httpd) {
            try {
                httpd.init();
            }
            catch (Throwable e) {
                log.warn("Error starting web server", e);
                httpd = null;
            }
        }
        this.httpd = httpd;
        if (!GraphicsEnvironment.isHeadless() && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            if (null != httpd) {
                new Thread(() -> {
                    try {
                        while (!this.httpd.isAlive()) {
                            Thread.sleep(100L);
                        }
                        if (this.isAutobrowse()) {
                            Desktop.getDesktop().browse(new URI(String.format("http://localhost:%d", httpPort)));
                        }
                    }
                    catch (IOException | InterruptedException | URISyntaxException e) {
                        e.printStackTrace();
                    }
                }).start();
            }
            this.onComplete(() -> {
                try {
                    if (this.isAutobrowse()) {
                        Desktop.getDesktop().browse(new File(this.getRoot(), this.getName() + ".html").toURI());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (null != httpd) {
            this.onComplete(() -> this.httpd.stop());
        }
    }

    public static Consumer<NotebookOutput> wrapFrontmatter(@Nonnull Consumer<NotebookOutput> fn) {
        return log -> {
            TimedResult<Void> time = TimedResult.time(() -> {
                try {
                    fn.accept((NotebookOutput)log);
                    log.setFrontMatterProperty("result", "OK");
                }
                catch (Throwable e) {
                    log.setFrontMatterProperty("result", MarkdownNotebookOutput.getExceptionString(e).toString().replaceAll("\n", "<br/>").trim());
                    throw (RuntimeException)(e instanceof RuntimeException ? e : new RuntimeException(e));
                }
            });
            log.setFrontMatterProperty("execution_time", String.format("%.6f", (double)time.timeNanos / 1.0E9));
        };
    }

    public static NotebookOutput get(File path, boolean autobrowse) {
        try {
            StackTraceElement callingFrame = Thread.currentThread().getStackTrace()[2];
            String methodName = callingFrame.getMethodName();
            path.getAbsoluteFile().getParentFile().mkdirs();
            return new MarkdownNotebookOutput(new File(path, methodName), autobrowse);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static CharSequence getExceptionString(Throwable e) {
        if (e instanceof RuntimeException && e.getCause() != null && e.getCause() != e) {
            return MarkdownNotebookOutput.getExceptionString(e.getCause());
        }
        if (e.getCause() != null && e.getCause() != e) {
            return e.getClass().getSimpleName() + " / " + MarkdownNotebookOutput.getExceptionString(e.getCause());
        }
        return e.getClass().getSimpleName();
    }

    public static NotebookOutput get(String s) {
        return MarkdownNotebookOutput.get(new File(s), true);
    }

    public static String stripPrefixes(String str, String ... prefixes) {
        AtomicReference<String> reference = new AtomicReference<String>(str);
        while (Stream.of(prefixes).filter(reference.get()::startsWith).findFirst().isPresent()) {
            reference.set(reference.get().substring(1));
        }
        return reference.get();
    }

    @Override
    public void close() throws IOException {
        if (null != this.primaryOut) {
            this.primaryOut.close();
        }
        try (PrintWriter out = new PrintWriter(new FileOutputStream(this.getReportFile()));){
            this.write(out);
        }
        File root = this.getRoot();
        this.write();
        this.writeZip(root, this.getName().toString());
        this.onComplete.stream().forEach(fn -> {
            try {
                fn.run();
            }
            catch (Throwable e) {
                log.info("Error closing log", e);
            }
        });
    }

    @Override
    @Nonnull
    public File getRoot() {
        return this.root;
    }

    public File writeZip(File root, String baseName) throws IOException {
        File zipFile = new File(root, baseName + ".zip");
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));){
            this.zipArchive(root, root, out, file -> !file.getName().equals(baseName + ".zip") && !file.getName().endsWith(".pdf"));
        }
        return zipFile;
    }

    @Override
    @Nonnull
    public NotebookOutput onComplete(Runnable ... tasks) {
        Arrays.stream(tasks).forEach(this.onComplete::add);
        return this;
    }

    @Nonnull
    public String toString(List<CharSequence> list) {
        if (list.size() > 0 && list.stream().allMatch(x -> {
            if (x.length() > 1) {
                char c = x.charAt(0);
                return c == ' ' || c == '\t';
            }
            return false;
        })) {
            return this.toString(list.stream().map(x -> x.subSequence(1, x.length()).toString()).collect(Collectors.toList()));
        }
        return ((CharSequence)list.stream().reduce((a, b) -> a + "\n" + b).orElse("")).toString();
    }

    public void zipArchive(File root, File dir, ZipOutputStream out, Predicate<? super File> filter) {
        Arrays.stream(dir.listFiles()).filter(filter).forEach(file -> {
            if (file.isDirectory()) {
                this.zipArchive(root, (File)file, out, filter);
            } else {
                String absRoot = root.getAbsolutePath();
                String absFile = file.getAbsolutePath();
                String relativeFile = absFile.substring(absRoot.length());
                if (relativeFile.startsWith(File.separator)) {
                    relativeFile = relativeFile.substring(1);
                }
                try {
                    out.putNextEntry(new ZipEntry(relativeFile));
                    IOUtils.copy((InputStream)new FileInputStream((File)file), (OutputStream)out);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void write(PrintWriter out) {
        if (!this.frontMatter.isEmpty()) {
            out.println("---");
            this.frontMatter.forEach((key, value) -> {
                String escaped = StringEscapeUtils.escapeJson((String)String.valueOf(value)).replaceAll("\n", " ").replaceAll(":", "&#58;").replaceAll("\\{", "\\{").replaceAll("\\}", "\\}");
                out.println(String.format("%s: %s", key, escaped));
            });
            out.println("---");
        }
        this.toc.forEach(out::println);
        out.print("\n\n");
        this.markdownData.forEach(out::println);
    }

    @Override
    public void setFrontMatterProperty(CharSequence key, CharSequence value) {
        this.frontMatter.put(key, value);
    }

    @Override
    public CharSequence getFrontMatterProperty(CharSequence key) {
        return this.frontMatter.get(key);
    }

    @Override
    public CharSequence getName() {
        return this.name;
    }

    public CharSequence anchor(CharSequence anchorId) {
        return String.format("<a id=\"%s\"></a>", anchorId);
    }

    public CharSequence anchorId() {
        return String.format("p-%d", this.anchor++);
    }

    @Override
    public void write() throws IOException {
        MutableDataSet options = new MutableDataSet();
        File htmlFile = this.writeHtml(options);
        this.writePdf(options, htmlFile);
    }

    private synchronized File writePdf(MutableDataSet options, File htmlFile) throws IOException {
        File root = this.getRoot();
        CharSequence baseName = this.getName();
        try (FileOutputStream out = new FileOutputStream(new File(root, baseName + ".pdf"));){
            PdfConverterExtension.exportToPdf((OutputStream)out, (String)FileUtils.readFileToString((File)htmlFile, (String)"UTF-8"), (String)htmlFile.getAbsoluteFile().toURI().toString(), (DataHolder)options);
        }
        return new File(htmlFile.getPath().replaceAll("\\.html$", ".pdf"));
    }

    private synchronized File writeHtml(MutableDataSet options) throws IOException {
        List<Extension> extensions = Arrays.asList(TablesExtension.create(), SubscriptExtension.create(), EscapedCharacterExtension.create());
        Parser parser = Parser.builder((DataHolder)options).extensions(extensions).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).extensions(extensions).escapeHtml(false).indentSize(2).softBreak("\n").build();
        String txt = this.toString(this.toc) + "\n\n" + this.toString(this.markdownData);
        FileUtils.write((File)new File(this.getRoot(), this.getName() + ".md"), (CharSequence)txt, (String)"UTF-8");
        File htmlFile = new File(this.getRoot(), this.getName() + ".html");
        String html = renderer.render((Node)parser.parse(txt));
        html = "<html><body>" + html + "</body></html>";
        try (FileOutputStream out = new FileOutputStream(htmlFile);){
            IOUtils.write((String)html, (OutputStream)out, (Charset)Charset.forName("UTF-8"));
        }
        log.info("Wrote " + htmlFile, (Throwable)new RuntimeException("Stack Trace"));
        return htmlFile;
    }

    @Override
    @Nonnull
    public OutputStream file(@Nonnull CharSequence name) {
        try {
            return new FileOutputStream(this.resolveResource(name));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public File resolveResource(@Nonnull CharSequence name) {
        return new File(this.getResourceDir(), Util.stripPrefix(name.toString(), "etc/"));
    }

    @Override
    @Nonnull
    public String file(CharSequence data, CharSequence caption) {
        return this.file(data, (CharSequence)(++excerptNumber + ".txt"), caption);
    }

    @Override
    @Nonnull
    public CharSequence file(@Nonnull byte[] data, @Nonnull CharSequence filename, CharSequence caption) {
        return this.file(new String(data, Charset.forName("UTF-8")), filename, caption);
    }

    @Override
    @Nonnull
    public String file(@Nullable CharSequence data, @Nonnull CharSequence fileName, CharSequence caption) {
        try {
            if (null != data) {
                IOUtils.write((CharSequence)data, (OutputStream)new FileOutputStream(new File(this.getResourceDir(), fileName.toString())), (Charset)Charset.forName("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "[" + caption + "](etc/" + fileName + ")";
    }

    @Override
    @Nonnull
    public File getResourceDir() {
        File etc = new File(this.getReportFile().getParentFile(), "etc").getAbsoluteFile();
        etc.mkdirs();
        return etc;
    }

    @Override
    public void h1(@Nonnull CharSequence fmt, Object ... args) {
        CharSequence anchorId = this.anchorId();
        String msg = this.format(fmt, args);
        this.toc.add(String.format("1. [%s](#%s)", msg, anchorId));
        this.out("# " + this.anchor(anchorId) + msg, new Object[0]);
    }

    @Override
    public void h2(@Nonnull CharSequence fmt, Object ... args) {
        CharSequence anchorId = this.anchorId();
        String msg = this.format(fmt, args);
        this.toc.add(String.format("   1. [%s](#%s)", msg, anchorId));
        this.out("## " + this.anchor(anchorId) + fmt, args);
    }

    @Override
    public void h3(@Nonnull CharSequence fmt, Object ... args) {
        CharSequence anchorId = this.anchorId();
        String msg = this.format(fmt, args);
        this.toc.add(String.format("      1. [%s](#%s)", msg, anchorId));
        this.out("### " + this.anchor(anchorId) + fmt, args);
    }

    @Override
    @Nonnull
    public String png(@Nullable BufferedImage rawImage, CharSequence caption) {
        if (null == rawImage) {
            return "";
        }
        File file = this.pngFile(rawImage, new File(this.getResourceDir(), this.getName() + "." + ++imageNumber + ".png"));
        return this.anchor(this.anchorId()) + "![" + caption + "](etc/" + file.getName() + ")";
    }

    @Override
    @Nonnull
    public File pngFile(@Nonnull BufferedImage rawImage, File file) {
        BufferedImage stdImage = Util.maximumSize(rawImage, this.getMaxImageSize());
        try {
            if (stdImage != rawImage) {
                String rawName = file.getName().replace(".png", "_raw.png");
                ImageIO.write((RenderedImage)rawImage, "png", new File(file.getParent(), rawName));
            }
            ImageIO.write((RenderedImage)stdImage, "png", file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    @Override
    @Nonnull
    public String jpg(@Nullable BufferedImage rawImage, CharSequence caption) {
        if (null == rawImage) {
            return "";
        }
        File file = this.jpgFile(rawImage, new File(this.getResourceDir(), this.getName() + "." + ++imageNumber + ".jpg"));
        return this.anchor(this.anchorId()) + "![" + caption + "](etc/" + file.getName() + ")";
    }

    @Override
    @Nonnull
    public File jpgFile(@Nonnull BufferedImage rawImage, File file) {
        BufferedImage stdImage = Util.maximumSize(rawImage, this.getMaxImageSize());
        if (stdImage != rawImage) {
            try {
                String rawName = file.getName().replace(".jpg", "_raw.jpg");
                ImageIO.write((RenderedImage)rawImage, "jpg", new File(file.getParent(), rawName));
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error processing image with dims (%d,%d)", rawImage.getWidth(), rawImage.getHeight()), e);
            }
        }
        try {
            ImageIO.write((RenderedImage)stdImage, "jpg", file);
        }
        catch (Throwable e) {
            log.warn(String.format("Error processing image with dims (%d,%d)", stdImage.getWidth(), stdImage.getHeight()), e);
        }
        return file;
    }

    @Override
    public <T> T eval(@Nonnull UncheckedSupplier<T> fn, int maxLog, int framesNo) {
        try {
            StackTraceElement callingFrame = Thread.currentThread().getStackTrace()[framesNo];
            String sourceCode = CodeUtil.getInnerText(callingFrame);
            SysOutInterceptor.LoggedResult<TimedResult> result = SysOutInterceptor.withOutput(() -> {
                long priorGcMs = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum();
                long start = System.nanoTime();
                try {
                    Object result1 = null;
                    try {
                        result1 = fn.get();
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    long gcTime = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum() - priorGcMs;
                    return new TimedResult<Object>(result1, System.nanoTime() - start, gcTime);
                }
                catch (Throwable e) {
                    long gcTime = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum() - priorGcMs;
                    return new TimedResult<Throwable>(e, System.nanoTime() - start, gcTime);
                }
            });
            this.out(this.anchor(this.anchorId()) + "Code from [%s:%s](%s#L%s) executed in %.2f seconds (%.3f gc): ", callingFrame.getFileName(), callingFrame.getLineNumber(), CodeUtil.codeUrl(callingFrame), callingFrame.getLineNumber(), ((TimedResult)result.obj).seconds(), ((TimedResult)result.obj).gc_seconds());
            this.out("```java", new Object[0]);
            this.out("  " + sourceCode.replaceAll("\n", "\n  "), new Object[0]);
            this.out("```", new Object[0]);
            if (!result.log.isEmpty()) {
                String summary = this.summarize(result.log, maxLog).replaceAll("\n", "\n    ").replaceAll("    ~", "");
                this.out(this.anchor(this.anchorId()) + "Logging: ", new Object[0]);
                this.out("```", new Object[0]);
                this.out("    " + summary, new Object[0]);
                this.out("```", new Object[0]);
            }
            this.out("", new Object[0]);
            Object eval = ((TimedResult)result.obj).result;
            if (null != eval) {
                String fmt;
                boolean escape;
                String str;
                this.out(this.anchor(this.anchorId()) + "Returns: \n", new Object[0]);
                if (eval instanceof Throwable) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ((Throwable)eval).printStackTrace(new PrintStream(out));
                    str = new String(out.toByteArray(), "UTF-8");
                    escape = true;
                } else if (eval instanceof Component) {
                    str = this.png(Util.toImage((Component)eval), "Result");
                    escape = false;
                } else if (eval instanceof BufferedImage) {
                    str = this.png((BufferedImage)eval, "Result");
                    escape = false;
                } else if (eval instanceof TableOutput) {
                    str = ((TableOutput)eval).toMarkdownTable();
                    escape = false;
                } else {
                    str = eval.toString();
                    escape = true;
                }
                String string = fmt = escape ? "    " + this.summarize(str, maxLog).replaceAll("\n", "\n    ").replaceAll("    ~", "") : str;
                if (escape) {
                    this.out("```", new Object[0]);
                    this.out(fmt, new Object[0]);
                    this.out("```", new Object[0]);
                } else {
                    this.out(fmt, new Object[0]);
                }
                this.out("\n\n", new Object[0]);
                if (eval instanceof RuntimeException) {
                    throw (RuntimeException)((TimedResult)result.obj).result;
                }
                if (eval instanceof Throwable) {
                    throw new RuntimeException((Throwable)((TimedResult)result.obj).result);
                }
            }
            return eval;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public CharSequence link(@Nonnull File file, CharSequence text) {
        try {
            return "[" + text + "](" + URLEncoder.encode(this.pathTo(file).toString(), "UTF-8") + ")";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public CharSequence pathTo(@Nonnull File file) {
        return Util.stripPrefix(Util.toString(Util.pathToFile(this.getReportFile(), file)), "/");
    }

    @Override
    public void out(@Nonnull String fmt, Object ... args) {
        String msg = this.format(fmt, args);
        this.markdownData.add(msg);
        this.primaryOut.println(msg);
        log.info(msg);
    }

    @Nonnull
    public String format(@Nonnull CharSequence fmt, Object ... args) {
        return 0 == args.length ? fmt.toString() : String.format(fmt.toString(), args);
    }

    @Override
    public void p(CharSequence fmt, Object ... args) {
        this.out(this.anchor(this.anchorId()).toString() + fmt + "\n", args);
    }

    @Nonnull
    public String summarize(@Nonnull String logSrc, int maxLog) {
        if (logSrc.length() > maxLog * 2) {
            String prefix = logSrc.substring(0, maxLog);
            logSrc = prefix + String.format((prefix.endsWith("\n") ? "" : "\n") + "~```\n~..." + this.file(logSrc, "skipping %s bytes") + "...\n~```\n", logSrc.length() - 2 * maxLog) + logSrc.substring(logSrc.length() - maxLog);
        }
        return logSrc;
    }

    @Override
    public int getMaxOutSize() {
        return MAX_OUTPUT;
    }

    @Override
    public FileHTTPD getHttpd() {
        return null != this.httpd ? this.httpd : new NullHTTPD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T subreport(String subreportName, Function<NotebookOutput, T> fn) {
        String reportName = this.getName() + subreportName;
        final MarkdownNotebookOutput outer = this;
        try {
            File root = this.getRoot();
            File subreportFile = new File(root, reportName);
            MarkdownNotebookOutput subreport = new MarkdownNotebookOutput(subreportFile, -1, false){

                @Override
                public FileHTTPD getHttpd() {
                    return outer.getHttpd();
                }

                @Override
                public File writeZip(File root, String baseName) {
                    return root;
                }
            };
            try {
                NotebookOutput e2;
                try {
                    outer.p("Subreport: %s %s %s %s", MarkdownNotebookOutput.stripPrefixes(URLDecoder.decode(subreportName, "UTF-8"), "_", "/", "-", " ", "."), outer.link(subreportFile, "markdown"), outer.link(new File(root, reportName + ".html"), "html"), outer.link(new File(root, reportName + ".pdf"), "pdf"));
                }
                catch (UnsupportedEncodingException e2) {
                    throw new RuntimeException(e2);
                }
                this.getHttpd().addGET(reportName + ".html", "text/html", out -> {
                    try {
                        subreport.write();
                        try (FileInputStream input = new FileInputStream(new File(root, subreport.getName() + ".html"));){
                            IOUtils.copy((InputStream)input, (OutputStream)out);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                this.getHttpd().addGET(reportName + ".pdf", "application/pdf", out -> {
                    try {
                        subreport.write();
                        try (FileInputStream input = new FileInputStream(new File(root, subreport.getName() + ".pdf"));){
                            IOUtils.copy((InputStream)input, (OutputStream)out);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                try {
                    e2 = fn.apply(subreport);
                }
                catch (Throwable e3) {
                    Object object = subreport.eval(() -> {
                        throw e3;
                    });
                    try {
                        subreport.close();
                    }
                    catch (IOException e6) {
                        throw new RuntimeException(e6);
                    }
                    return (T)object;
                }
                return (T)e2;
            }
            finally {
                try {
                    subreport.close();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        catch (FileNotFoundException e5) {
            throw new RuntimeException(e5);
        }
    }

    public boolean isAutobrowse() {
        return this.autobrowse;
    }

    public int getMaxImageSize() {
        return this.maxImageSize;
    }

    public NotebookOutput setMaxImageSize(int maxImageSize) {
        this.maxImageSize = maxImageSize;
        return this;
    }

    @Override
    public URI getCurrentHome() {
        return this.currentHome;
    }

    @Override
    public NotebookOutput setCurrentHome(URI currentHome) {
        this.currentHome = currentHome;
        return this;
    }

    @Override
    public URI getArchiveHome() {
        return this.archiveHome;
    }

    @Override
    public NotebookOutput setArchiveHome(URI archiveHome) {
        this.archiveHome = archiveHome;
        logger.info(String.format("Changed archive home to %s", archiveHome));
        return this;
    }

    @Override
    public NotebookOutput setName(String name) {
        this.name = name.replaceAll("\\.md$", "").replaceAll("\\$$", "").replaceAll("[:%\\{\\}\\(\\)\\+\\*]", "_").replaceAll("_{2,}", "_");
        int maxLength = 128;
        if (this.name.length() > maxLength) {
            this.name = this.name.substring(this.name.length() - maxLength);
        }
        return this;
    }

    @Nonnull
    public File getReportFile() {
        return new File(this.getRoot(), this.getName() + ".md");
    }

    @Override
    public NotebookOutput setAutobrowse(boolean autobrowse) {
        this.autobrowse = autobrowse;
        return this;
    }
}

