/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.notebook;

import com.simiacryptus.lang.UncheckedSupplier;
import com.simiacryptus.notebook.FileHTTPD;
import com.simiacryptus.notebook.NotebookOutput;
import com.simiacryptus.notebook.NullHTTPD;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NullNotebookOutput
implements NotebookOutput {
    private final String name;

    public NullNotebookOutput(String name) {
        this.name = name;
    }

    public NullNotebookOutput() {
        this("null");
    }

    @Override
    public void close() {
    }

    @Override
    @Nonnull
    public File pngFile(@Nonnull BufferedImage rawImage, File file) {
        return null;
    }

    @Override
    @Nonnull
    public String jpg(@Nullable BufferedImage rawImage, CharSequence caption) {
        return "";
    }

    @Override
    @Nonnull
    public File jpgFile(@Nonnull BufferedImage rawImage, File file) {
        return null;
    }

    @Override
    public <T> T eval(@Nonnull UncheckedSupplier<T> fn, int maxLog, int framesNo) {
        try {
            return fn.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write() throws IOException {
    }

    @Override
    @Nonnull
    public OutputStream file(@Nonnull CharSequence name) {
        return new ByteArrayOutputStream();
    }

    @Override
    @Nonnull
    public String file(@Nonnull CharSequence data, CharSequence caption) {
        return "";
    }

    @Override
    @Nonnull
    public CharSequence file(@Nonnull byte[] data, @Nonnull CharSequence filename, CharSequence caption) {
        return "";
    }

    @Override
    @Nonnull
    public String file(@Nonnull CharSequence data, @Nonnull CharSequence fileName, CharSequence caption) {
        return "";
    }

    @Override
    public void h1(CharSequence fmt, Object ... args) {
    }

    @Override
    public void h2(CharSequence fmt, Object ... args) {
    }

    @Override
    public void h3(CharSequence fmt, Object ... args) {
    }

    @Override
    @Nonnull
    public String png(BufferedImage rawImage, CharSequence caption) {
        return "";
    }

    @Override
    @Nonnull
    public CharSequence link(File file, CharSequence text) {
        return "";
    }

    @Override
    public void p(CharSequence fmt, Object ... args) {
    }

    @Override
    @Nonnull
    public File getRoot() {
        return new File(".");
    }

    @Override
    @Nonnull
    public NotebookOutput onComplete(Runnable ... tasks) {
        return this;
    }

    @Override
    @Nullable
    public CharSequence getFrontMatterProperty(CharSequence key) {
        return null;
    }

    @Override
    public CharSequence getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public File getResourceDir() {
        return new File(".");
    }

    @Override
    public int getMaxOutSize() {
        return 0;
    }

    @Override
    public FileHTTPD getHttpd() {
        return new NullHTTPD();
    }

    @Override
    public <T> T subreport(String reportName, Function<NotebookOutput, T> fn) {
        return fn.apply(new NullNotebookOutput(reportName));
    }

    @Override
    public URI getCurrentHome() {
        return new File(".").toURI();
    }

    @Override
    public NotebookOutput setCurrentHome(URI currentHome) {
        return this;
    }

    @Override
    public URI getArchiveHome() {
        return new File(".").toURI();
    }

    @Override
    public NotebookOutput setArchiveHome(URI archiveHome) {
        return this;
    }

    @Override
    public NotebookOutput setName(String name) {
        return this;
    }

    @Override
    public NotebookOutput setAutobrowse(boolean autobrowse) {
        return this;
    }
}

