/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.simiacryptus.util.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeUtil {
    private static final Logger logger = LoggerFactory.getLogger(CodeUtil.class);
    private static final List<CharSequence> sourceFolders = Arrays.asList("src/main/java", "src/test/java", "src/main/scala", "src/test/scala");
    @Nonnull
    public static File projectRoot = new File(System.getProperty("codeRoot", CodeUtil.getDefaultProjectRoot()));
    private static final List<File> codeRoots = CodeUtil.scanLocalCodeRoots();
    public static HashMap<String, String> classSourceInfo = CodeUtil.getDefaultClassInfo();

    private static String getDefaultProjectRoot() {
        if (new File("src").exists()) {
            return "..";
        }
        return ".";
    }

    @Nullable
    public static URI findFile(@Nullable Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        String name = clazz.getName();
        if (null == name) {
            return null;
        }
        String path = name.replaceAll("\\.", "/").replaceAll("\\$.*", "");
        return CodeUtil.findFile(path + ".java");
    }

    @Nonnull
    public static URI findFile(@Nonnull StackTraceElement callingFrame) {
        String[] packagePath = callingFrame.getClassName().split("\\.");
        String pkg = Arrays.stream(packagePath).limit(packagePath.length - 1).collect(Collectors.joining(File.separator));
        if (!pkg.isEmpty()) {
            pkg = pkg + File.separator;
        }
        String path = pkg + callingFrame.getFileName();
        return CodeUtil.findFile(path);
    }

    @Nonnull
    public static URI findFile(@Nonnull String path) {
        URL classpathEntry = ClassLoader.getSystemResource(path);
        if (classpathEntry != null) {
            try {
                logger.debug(String.format("Resolved %s to %s", path, classpathEntry));
                return classpathEntry.toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        for (File root : codeRoots) {
            File file = new File(root, path);
            if (!file.exists()) continue;
            logger.debug(String.format("Resolved %s to %s", path, file));
            return file.toURI();
        }
        throw new RuntimeException(String.format("Not Found: %s; Project Roots = %s", path, codeRoots));
    }

    @Nonnull
    public static CharSequence getIndent(@Nonnull CharSequence txt) {
        Matcher matcher = Pattern.compile("^\\s+").matcher(txt);
        return matcher.find() ? matcher.group(0) : "";
    }

    public static String getInnerText(@Nonnull StackTraceElement callingFrame) {
        String[] split = callingFrame.getClassName().split("\\.");
        String fileResource = Arrays.stream(split).limit(split.length - 1).reduce((a, b) -> a + "/" + b).orElse("") + "/" + callingFrame.getFileName();
        URL resource = ClassLoader.getSystemResource(fileResource);
        try {
            int lineNum;
            List allLines;
            if (null != resource) {
                try {
                    allLines = IOUtils.readLines((InputStream)resource.openStream(), (String)"UTF-8");
                    logger.debug(String.format("Resolved %s to %s (%s lines)", callingFrame, resource, allLines.size()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                URI file = CodeUtil.findFile(callingFrame);
                assert (null != file);
                allLines = IOUtils.readLines((InputStream)file.toURL().openStream(), (String)"UTF-8");
                logger.debug(String.format("Resolved %s to %s (%s lines)", callingFrame, file, allLines.size()));
            }
            int start = callingFrame.getLineNumber() - 1;
            CharSequence txt = (CharSequence)allLines.get(start);
            CharSequence indent = CodeUtil.getIndent(txt);
            ArrayList<String> lines = new ArrayList<String>();
            for (lineNum = start + 1; lineNum < allLines.size() && (CodeUtil.getIndent((CharSequence)allLines.get(lineNum)).length() > indent.length() || String.valueOf(allLines.get(lineNum)).trim().isEmpty()); ++lineNum) {
                String line = (String)allLines.get(lineNum);
                lines.add(line.substring(Math.min(indent.length(), line.length())));
            }
            logger.debug(String.format("Selected %s lines (%s to %s) for %s", lines.size(), start, lineNum, callingFrame));
            return lines.stream().collect(Collectors.joining("\n"));
        }
        catch (Throwable e) {
            logger.warn("Error assembling lines", e);
            return "";
        }
    }

    public static String getJavadoc(@Nullable Class<?> clazz) {
        try {
            if (null == clazz) {
                return null;
            }
            URI source = CodeUtil.findFile(clazz);
            if (null == source) {
                return clazz.getName() + " not found";
            }
            List lines = IOUtils.readLines((InputStream)source.toURL().openStream(), (Charset)Charset.forName("UTF-8"));
            int classDeclarationLine = IntStream.range(0, lines.size()).filter(i -> ((String)lines.get(i)).contains("class " + clazz.getSimpleName())).findFirst().getAsInt();
            int firstLine = IntStream.rangeClosed(1, classDeclarationLine).map(i -> classDeclarationLine - i).filter(i -> !((String)lines.get(i)).matches("\\s*[/\\*@].*")).findFirst().orElse(-1) + 1;
            String javadoc = lines.subList(firstLine, classDeclarationLine).stream().filter(s -> s.matches("\\s*[/\\*].*")).map(s -> s.replaceFirst("^[ \t]*[/\\*]+", "").trim()).filter(x -> !x.isEmpty()).reduce((a, b) -> a + "\n" + b).orElse("");
            return javadoc.replaceAll("<p>", "\n");
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    private static List<File> scanLocalCodeRoots() {
        return Stream.concat(Stream.of(projectRoot), Arrays.stream(projectRoot.listFiles()).filter(file -> file.exists() && file.isDirectory()).collect(Collectors.toList()).stream()).flatMap(x -> CodeUtil.scanProject(x).stream()).distinct().collect(Collectors.toList());
    }

    private static List<File> scanProject(File file) {
        return sourceFolders.stream().map(name -> new File(file, name.toString())).filter(f -> f.exists() && f.isDirectory()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> getDefaultClassInfo() {
        InputStream resourceAsStream = ClassLoader.getSystemResourceAsStream("META-INF/CodeUtil/classSourceInfo.json");
        if (null != resourceAsStream) {
            try {
                HashMap map = (HashMap)JsonUtil.getMapper().readValue(IOUtils.toString((InputStream)resourceAsStream, (String)"UTF-8"), HashMap.class);
                logger.debug("Class Info: " + JsonUtil.toJson(map));
                HashMap hashMap = map;
                return hashMap;
            }
            catch (Throwable e) {
                logger.warn("Error loading", e);
            }
            finally {
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {
                    logger.warn("Error closing", (Throwable)e);
                }
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        CodeUtil.scanLocalCodeRoots().stream().map(f -> f.getParentFile().getParentFile().getParentFile().getAbsoluteFile()).distinct().forEach(root -> {
            String base = CodeUtil.getGitBase(root, "");
            if (!base.isEmpty()) {
                File src = new File((File)root, "src");
                FileUtils.listFiles((File)src, null, (boolean)true).forEach(file -> {
                    try {
                        map.put(src.getCanonicalFile().toPath().relativize(file.getCanonicalFile().toPath()).toString().replace('\\', '/'), base);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        });
        logger.debug("Class Info: " + JsonUtil.toJson(map));
        return map;
    }

    protected static String getGitBase(File absoluteFile, String def) {
        try {
            Repository repository = ((RepositoryBuilder)new RepositoryBuilder().setWorkTree(absoluteFile)).build();
            StoredConfig config = repository.getConfig();
            String head = repository.resolve("HEAD").toObjectId().getName();
            String remoteUrl = config.getString("remote", "origin", "url");
            Pattern githubPattern = Pattern.compile("git@github.com:([^/]+)/([^/]+).git");
            Matcher matcher = githubPattern.matcher(remoteUrl);
            if (matcher.matches()) {
                return "https://github.com/" + matcher.group(1) + "/" + matcher.group(2) + "/tree/" + head + "/src/";
            }
        }
        catch (Throwable e) {
            logger.debug("Error querying local git config for " + absoluteFile, e);
        }
        return def;
    }

    public static CharSequence codeUrl(StackTraceElement callingFrame) {
        String[] split = callingFrame.getClassName().split("\\.");
        String packagePath = Arrays.asList(split).subList(0, split.length - 1).stream().reduce((a, b) -> a + "/" + b).orElse("");
        String[] fileSplit = callingFrame.getFileName().split("\\.");
        String language = fileSplit[fileSplit.length - 1];
        String codePath = (language + "/" + packagePath + "/" + callingFrame.getFileName()).replaceAll("//", "/");
        if (classSourceInfo.containsKey("main/" + codePath)) {
            return classSourceInfo.get("main/" + codePath) + "main/" + codePath;
        }
        if (classSourceInfo.containsKey("test/" + codePath)) {
            return classSourceInfo.get("test/" + codePath) + "test/" + codePath;
        }
        return codePath;
    }
}

