/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.simiacryptus.util.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalAppSettings {
    private static final Logger logger = LoggerFactory.getLogger(LocalAppSettings.class);
    public final HashMap<String, String> properties = new HashMap();

    public LocalAppSettings(HashMap<String, String> properties) {
        this.properties.putAll(properties);
    }

    public static HashMap<String, String> read() {
        return LocalAppSettings.read(new File("."));
    }

    public static HashMap<String, String> read(File workingDir) {
        File parentFile = workingDir.getParentFile();
        File file = new File(workingDir, "app.json");
        if (file.exists()) {
            HashMap settings = null;
            try {
                settings = (HashMap)JsonUtil.getMapper().readValue(new String(FileUtils.readFileToByteArray((File)file), Charset.forName("UTF-8")), HashMap.class);
                settings.forEach((k, v) -> logger.info(String.format("Loaded %s = %s from %s", k, v, file)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (parentFile != null && parentFile.exists()) {
                settings.putAll(LocalAppSettings.read(parentFile));
            }
            return settings;
        }
        if (parentFile != null && parentFile.exists()) {
            return LocalAppSettings.read(parentFile);
        }
        return new HashMap<String, String>();
    }
}

