/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends InputStream {
    private final OutputStream cache;
    private final InputStream inputStream;

    public TeeInputStream(InputStream inputStream, OutputStream cache) {
        this.inputStream = inputStream;
        this.cache = cache;
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        this.cache.close();
    }

    @Override
    public int read() throws IOException {
        int read = this.inputStream.read();
        this.cache.write(read);
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.inputStream.read(b);
        if (read > 0) {
            this.cache.write(b);
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.inputStream.read(b, off, len);
        if (read > 0) {
            this.cache.write(b, off, read);
        }
        return read;
    }
}

