/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.notebook;

import com.simiacryptus.lang.UncheckedSupplier;
import com.simiacryptus.notebook.FileHTTPD;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface NotebookOutput
extends Closeable {
    public static Consumer<NotebookOutput> concat(@Nonnull Consumer<NotebookOutput> fn, @Nonnull Consumer<NotebookOutput> header) {
        return log -> {
            header.accept((NotebookOutput)log);
            fn.accept((NotebookOutput)log);
        };
    }

    default public void run(@Nonnull Runnable fn) {
        this.eval(() -> {
            fn.run();
            return null;
        }, this.getMaxOutSize(), 3);
    }

    default public <T> T eval(UncheckedSupplier<T> fn) {
        return this.eval(fn, this.getMaxOutSize(), 3);
    }

    default public <T> T out(UncheckedSupplier<T> fn) {
        return this.eval(fn, Integer.MAX_VALUE, 3);
    }

    @Nonnull
    public File pngFile(@Nonnull BufferedImage var1, File var2);

    @Nonnull
    public String jpg(@Nullable BufferedImage var1, CharSequence var2);

    @Nonnull
    public File jpgFile(@Nonnull BufferedImage var1, File var2);

    public <T> T eval(UncheckedSupplier<T> var1, int var2, int var3);

    public void write() throws IOException;

    @Nonnull
    public OutputStream file(CharSequence var1);

    @Nonnull
    public String file(CharSequence var1, CharSequence var2);

    @Nonnull
    public CharSequence file(byte[] var1, CharSequence var2, CharSequence var3);

    @Nonnull
    public String file(CharSequence var1, CharSequence var2, CharSequence var3);

    public void h1(CharSequence var1, Object ... var2);

    public void h2(CharSequence var1, Object ... var2);

    public void h3(CharSequence var1, Object ... var2);

    @Nonnull
    public String png(BufferedImage var1, CharSequence var2);

    public CharSequence link(File var1, CharSequence var2);

    default public void out(CharSequence fmt, Object ... args) {
        this.p(fmt, args);
    }

    public void p(CharSequence var1, Object ... var2);

    @Nonnull
    public File getRoot();

    @Nonnull
    public NotebookOutput onComplete(Runnable ... var1);

    @Override
    public void close() throws IOException;

    default public void setFrontMatterProperty(CharSequence key, CharSequence value) {
    }

    default public void appendFrontMatterProperty(CharSequence key, CharSequence value, CharSequence delimiter) {
        CharSequence prior = this.getFrontMatterProperty(key);
        if (null == prior) {
            this.setFrontMatterProperty(key, value);
        } else {
            this.setFrontMatterProperty(key, prior.toString() + delimiter + value);
        }
    }

    @Nullable
    public CharSequence getFrontMatterProperty(CharSequence var1);

    public CharSequence getName();

    public NotebookOutput setName(String var1);

    @Nonnull
    public File getResourceDir();

    public int getMaxOutSize();

    public FileHTTPD getHttpd();

    public <T> T subreport(String var1, Function<NotebookOutput, T> var2);

    public URI getCurrentHome();

    public NotebookOutput setCurrentHome(URI var1);

    public URI getArchiveHome();

    public NotebookOutput setArchiveHome(URI var1);

    public NotebookOutput setAutobrowse(boolean var1);
}

