/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.notebook;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.simiacryptus.notebook.FileHTTPD;
import com.simiacryptus.notebook.JsonQuery;
import com.simiacryptus.notebook.MarkdownNotebookOutput;
import com.simiacryptus.notebook.NanoHTTPD;
import com.simiacryptus.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StringQuery<T> {
    protected static final Logger logger = LoggerFactory.getLogger(JsonQuery.class);
    protected final String id = "input_" + UUID.randomUUID().toString() + ".html";
    protected final Closeable handler_get;
    protected final Semaphore done = new Semaphore(0);
    protected final Closeable handler_post;
    final MarkdownNotebookOutput log;
    protected T value = null;
    String width = "100%";
    String formVar = "data";
    private String height1 = "200px";
    private String height2 = "240px";

    public StringQuery(MarkdownNotebookOutput log) {
        this.log = log;
        FileHTTPD httpd = this.log.getHttpd();
        this.handler_get = httpd.addGET(this.id, "text/html", out -> {
            try {
                if (this.done.tryAcquire()) {
                    this.done.release();
                    IOUtil.writeString(this.getRead(), out);
                } else {
                    IOUtil.writeString(this.getWrite(), out);
                }
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        this.handler_post = httpd.addPOST(this.id, request -> {
            String responseHtml;
            try {
                Map<String, String> parms = request.getParms();
                HashMap<String, String> files = new HashMap<String, String>();
                request.parseBody(files);
                String text = parms.get(this.formVar);
                logger.info("Json input: " + text);
                this.value = this.fromString(text);
                this.done.release();
                responseHtml = this.getRead();
                FileUtils.write((File)new File(log.getRoot(), this.id), (CharSequence)responseHtml, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            byte[] bytes = responseHtml.getBytes();
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/html", new ByteArrayInputStream(bytes), bytes.length);
        });
    }

    protected String getWrite() throws JsonProcessingException {
        return "<html><body style=\"margin: 0;\"><form action=\"" + this.id + "\" method=\"POST\"><textarea name=\"" + this.formVar + "\" style=\"margin: 0px; width: " + this.width + "; height: " + this.height1 + ";\">" + this.getString(this.value) + "</textarea><br/><input type=\"submit\"></form></body></html>";
    }

    private String getRead() throws JsonProcessingException {
        return "<html><body style=\"margin: 0;\"><textarea name=\"" + this.formVar + "\" style=\"margin: 0px; width: " + this.width + "; height: " + this.height2 + ";\">" + this.getString(this.value) + "</textarea></body></html>";
    }

    protected abstract T fromString(String var1) throws IOException;

    protected abstract String getString(T var1) throws JsonProcessingException;

    public StringQuery<T> print(@Nonnull T initial) {
        this.value = initial;
        try {
            int textLines = this.getString(this.value).split("\n").length;
            int lines = (int)((double)Math.max(Math.min(textLines, 20), 3) * 16.666666666666668);
            this.height1 = String.format("%dpx", lines);
            this.height2 = String.format("%dpx", lines + 40);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.log.p("<iframe src=" + this.id + " style=\"margin: 0px; width: 100%; height: " + this.height2 + ";\"></iframe>", new Object[0]);
        return this;
    }

    public T get() {
        try {
            this.done.acquire();
            this.done.release();
            return this.value;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public T get(long t, TimeUnit u) {
        try {
            if (this.done.tryAcquire(t, u)) {
                this.done.release();
                return this.value;
            }
            return this.value;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void finalize() throws Throwable {
        if (null != this.handler_get) {
            this.handler_get.close();
        }
        if (null != this.handler_post) {
            this.handler_post.close();
        }
        super.finalize();
    }

    public static class SimpleStringQuery
    extends StringQuery<String> {
        public SimpleStringQuery(MarkdownNotebookOutput log) {
            super(log);
        }

        @Override
        protected String fromString(String text) {
            return text;
        }

        @Override
        protected String getString(String value) {
            return value;
        }
    }
}

