/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.data;

import java.util.Arrays;
import java.util.DoubleSummaryStatistics;
import java.util.stream.Collector;
import javax.annotation.Nonnull;

public class DoubleStatistics
extends DoubleSummaryStatistics {
    @Nonnull
    public static Collector<Double, DoubleStatistics, DoubleStatistics> COLLECTOR = Collector.of(DoubleStatistics::new, DoubleStatistics::accept, DoubleStatistics::combine, d -> d, new Collector.Characteristics[0]);
    @Nonnull
    public static Collector<Number, DoubleStatistics, DoubleStatistics> NUMBERS = Collector.of(DoubleStatistics::new, (a, n) -> a.accept(n.doubleValue()), DoubleStatistics::combine, d -> d, new Collector.Characteristics[0]);
    private double simpleSumOfSquare;
    private double sumOfSquare = 0.0;
    private double sumOfSquareCompensation;

    @Override
    public synchronized void accept(double value) {
        super.accept(value);
        double squareValue = value * value;
        this.simpleSumOfSquare += squareValue;
        this.sumOfSquareWithCompensation(squareValue);
    }

    @Nonnull
    public DoubleStatistics accept(@Nonnull double[] value) {
        Arrays.stream(value).forEach(this::accept);
        return this;
    }

    @Nonnull
    public DoubleStatistics combine(@Nonnull DoubleStatistics other) {
        super.combine(other);
        this.simpleSumOfSquare += other.simpleSumOfSquare;
        this.sumOfSquareWithCompensation(other.sumOfSquare);
        this.sumOfSquareWithCompensation(other.sumOfSquareCompensation);
        return this;
    }

    public final double getStandardDeviation() {
        return this.getCount() > 0L ? Math.sqrt(this.getSumOfSquare() / (double)this.getCount() - Math.pow(this.getAverage(), 2.0)) : 0.0;
    }

    public double getSumOfSquare() {
        double tmp = this.sumOfSquare + this.sumOfSquareCompensation;
        if (Double.isNaN(tmp) && Double.isInfinite(this.simpleSumOfSquare)) {
            return this.simpleSumOfSquare;
        }
        return tmp;
    }

    private void sumOfSquareWithCompensation(double value) {
        double tmp = value - this.sumOfSquareCompensation;
        double velvel = this.sumOfSquare + tmp;
        this.sumOfSquareCompensation = velvel - this.sumOfSquare - tmp;
        this.sumOfSquare = velvel;
    }

    @Override
    public String toString() {
        return this.toString(1.0).toString();
    }

    public CharSequence toString(double scale) {
        return String.format("%.4e +- %.4e [%.4e - %.4e] (%d#)", this.getAverage() * scale, this.getStandardDeviation() * scale, this.getMin() * scale, this.getMax() * scale, this.getCount());
    }
}

