/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public final class BinaryChunkIterator
implements Iterator<byte[]> {
    private final DataInputStream in;
    private final int recordSize;

    public BinaryChunkIterator(DataInputStream in, int recordSize) {
        this.in = in;
        this.recordSize = recordSize;
    }

    @Nonnull
    private static byte[] read(@Nonnull DataInputStream i, int s) throws IOException {
        int read;
        byte[] b = new byte[s];
        for (int pos = 0; b.length > pos; pos += read) {
            read = i.read(b, pos, b.length - pos);
            if (0 != read) continue;
            throw new RuntimeException();
        }
        return b;
    }

    public static <T> Stream<T> toIterator(@Nonnull Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliterator(iterator, 1L, 16), false);
    }

    public static <T> Stream<T> toStream(@Nonnull Iterator<T> iterator) {
        return BinaryChunkIterator.toStream(iterator, 0);
    }

    public static <T> Stream<T> toStream(@Nonnull Iterator<T> iterator, int size) {
        return BinaryChunkIterator.toStream(iterator, size, false);
    }

    public static <T> Stream<T> toStream(@Nonnull Iterator<T> iterator, int size, boolean parallel) {
        return StreamSupport.stream(Spliterators.spliterator(iterator, (long)size, 16), parallel);
    }

    @Override
    public boolean hasNext() {
        try {
            return 0 < this.in.available();
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    @Nonnull
    public byte[] next() {
        assert (this.hasNext());
        try {
            return BinaryChunkIterator.read(this.in, this.recordSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Stream<byte[]> toStream() {
        return BinaryChunkIterator.toStream(this);
    }
}

