/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.simiacryptus.util.MonitoredItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class MonitoredObject
implements MonitoredItem {
    private final Map<CharSequence, Object> items = new HashMap<CharSequence, Object>();

    @Nonnull
    public MonitoredObject addConst(CharSequence key, Object item) {
        this.items.put(key, item);
        return this;
    }

    @Nonnull
    public MonitoredObject addField(CharSequence key, Supplier<Object> item) {
        this.items.put(key, item);
        return this;
    }

    @Nonnull
    public MonitoredObject addObj(CharSequence key, MonitoredItem item) {
        this.items.put(key, item);
        return this;
    }

    @Nonnull
    public MonitoredObject clearConstants() {
        HashSet<CharSequence> keys = new HashSet<CharSequence>(this.items.keySet());
        for (CharSequence k : keys) {
            Object v = this.items.get(k);
            if (v instanceof MonitoredObject) {
                ((MonitoredObject)v).clearConstants();
                continue;
            }
            if (v instanceof Supplier || v instanceof MonitoredItem) continue;
            this.items.remove(k);
        }
        return this;
    }

    @Override
    @Nonnull
    public Map<CharSequence, Object> getMetrics() {
        HashMap<CharSequence, Object> returnValue = new HashMap<CharSequence, Object>();
        ((Stream)this.items.entrySet().stream().parallel()).forEach(e -> {
            CharSequence k = (CharSequence)e.getKey();
            Object v = e.getValue();
            if (v instanceof MonitoredItem) {
                returnValue.put(k, ((MonitoredItem)v).getMetrics());
            } else if (v instanceof Supplier) {
                returnValue.put(k, ((Supplier)v).get());
            } else {
                returnValue.put(k, v);
            }
        });
        return returnValue;
    }
}

