/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;

public class FairAsyncWorkQueue
implements Runnable {
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final ExecutorService pool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).build());
    private final LinkedBlockingDeque<Runnable> queue = new LinkedBlockingDeque();

    @Override
    public void run() {
        if (this.isRunning.getAndSet(true)) {
            try {
                Runnable poll;
                while (null != (poll = this.queue.poll())) {
                    poll.run();
                }
            }
            finally {
                this.isRunning.set(false);
            }
        }
    }

    public void submit(Runnable task) {
        this.queue.add(task);
        this.pool.submit(this);
    }
}

