/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.notebook;

import com.simiacryptus.util.data.DoubleStatistics;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableOutput {
    public static final Logger logger = LoggerFactory.getLogger(TableOutput.class);
    public final List<Map<CharSequence, Object>> rows = new ArrayList<Map<CharSequence, Object>>();
    public final Map<CharSequence, Class<?>> schema = new LinkedHashMap();

    @Nonnull
    public static TableOutput create(Map<CharSequence, Object> ... rows) {
        TableOutput table = new TableOutput();
        Arrays.stream(rows).forEach(table::putRow);
        return table;
    }

    @Nonnull
    public TableOutput calcNumberStats() {
        TableOutput tableOutput = new TableOutput();
        this.schema.entrySet().stream().filter(x -> Number.class.isAssignableFrom((Class)x.getValue())).map(col -> {
            CharSequence key = (CharSequence)col.getKey();
            DoubleStatistics stats = this.rows.stream().filter(x -> x.containsKey(key)).map(x -> (Number)x.get(key)).collect(DoubleStatistics.NUMBERS);
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            row.put("field", key);
            row.put("sum", stats.getSum());
            row.put("avg", stats.getAverage());
            row.put("stddev", stats.getStandardDeviation());
            row.put("nulls", (long)this.rows.size() - stats.getCount());
            return row;
        }).sorted(Comparator.comparing(x -> x.get("field").toString())).forEach(row -> tableOutput.putRow((Map<? extends CharSequence, ? extends Object>)row));
        return tableOutput;
    }

    public void clear() {
        this.schema.clear();
        this.rows.clear();
    }

    public void putRow(@Nonnull Map<? extends CharSequence, ? extends Object> properties) {
        for (Map.Entry<? extends CharSequence, ? extends Object> prop : properties.entrySet()) {
            Object value;
            CharSequence propKey = prop.getKey();
            if (null == propKey || null == (value = prop.getValue())) continue;
            Class<?> cellType = value.getClass();
            Class<?> colType = this.schema.getOrDefault(propKey, cellType);
            if (!colType.isAssignableFrom(cellType)) {
                logger.warn(String.format("Schema mismatch for %s (%s != %s)", propKey, colType, cellType));
            }
            this.schema.putIfAbsent(propKey, cellType);
        }
        this.rows.add(new HashMap<CharSequence, Object>(properties));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CharSequence toCSV(boolean sortCols) {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            try (PrintStream printStream = new PrintStream(buffer);){
                Set<CharSequence> keys = sortCols ? new TreeSet<CharSequence>(this.schema.keySet()) : this.schema.keySet();
                String formatString = keys.stream().map(k -> {
                    switch (this.schema.get(k).getSimpleName()) {
                        case "String": {
                            return "%-" + this.rows.stream().mapToInt(x -> x.getOrDefault(k, "").toString().length()).max().getAsInt() + "s";
                        }
                        case "Integer": {
                            return "%6d";
                        }
                        case "Double": {
                            return "%.4f";
                        }
                    }
                    return "%s";
                }).collect(Collectors.joining(","));
                printStream.println(keys.stream().collect(Collectors.joining(",")).trim());
                for (Map<CharSequence, Object> row : this.rows) {
                    printStream.println(String.format(formatString, keys.stream().map(k -> row.get(k)).toArray()));
                }
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toHtmlTable() {
        return this.toHtmlTable(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toHtmlTable(boolean sortCols) {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            try (PrintStream printStream = new PrintStream(buffer);){
                Set<CharSequence> keys = sortCols ? new TreeSet<CharSequence>(this.schema.keySet()) : this.schema.keySet();
                String formatString = keys.stream().map(k -> {
                    switch (this.schema.get(k).getSimpleName()) {
                        case "String": {
                            return "%-" + this.rows.stream().mapToInt(x -> x.getOrDefault(k, "").toString().length()).max().getAsInt() + "s";
                        }
                        case "Integer": {
                            return "%6d";
                        }
                        case "Double": {
                            return "%.4f";
                        }
                    }
                    return "%s";
                }).map(s -> "<td>" + s + "</td>").collect(Collectors.joining(""));
                printStream.print("<table border=1>");
                printStream.print("<tr>");
                printStream.println(keys.stream().map(s -> "<th>" + s + "</th>").collect(Collectors.joining("")).trim());
                printStream.print("</tr>");
                for (Map<CharSequence, Object> row : this.rows) {
                    printStream.print("<tr>");
                    printStream.println(String.format(formatString, keys.stream().map(k -> row.get(k)).toArray()));
                    printStream.print("</tr>");
                }
                printStream.print("</table>");
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toMarkdownTable() {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            try (PrintStream printStream = new PrintStream(buffer);){
                String formatString = this.schema.entrySet().stream().map(e -> {
                    switch (((Class)e.getValue()).getSimpleName()) {
                        case "String": {
                            return "%-" + this.rows.stream().mapToInt(x -> {
                                String val = x.getOrDefault(e.getKey(), "");
                                return null == val ? 0 : val.toString().length();
                            }).max().getAsInt() + "s";
                        }
                        case "Integer": {
                            return "%6d";
                        }
                        case "Double": {
                            return "%.4f";
                        }
                    }
                    return "%s";
                }).collect(Collectors.joining(" | "));
                printStream.println(this.schema.entrySet().stream().map(x -> (CharSequence)x.getKey()).collect(Collectors.joining(" | ")).trim());
                printStream.println(this.schema.entrySet().stream().map(x -> (CharSequence)x.getKey()).map(x -> {
                    char[] t = new char[x.length()];
                    Arrays.fill(t, '-');
                    return new String(t);
                }).collect(Collectors.joining(" | ")).trim());
                for (Map<CharSequence, Object> row : this.rows) {
                    printStream.println(String.format(formatString, this.schema.entrySet().stream().map(e -> row.get(e.getKey())).toArray()));
                }
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void writeProjectorData(@Nonnull File path, URL baseUrl) throws IOException {
        Object object;
        PrintStream printStream5;
        Throwable throwable;
        Object printStream22;
        Object printStream3;
        path.mkdirs();
        try (FileOutputStream file = new FileOutputStream(new File(path, "data.tsv"));){
            printStream3 = new PrintStream(file);
            Throwable throwable2 = null;
            try {
                ((PrintStream)printStream3).println(this.toMarkdownTable());
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (printStream3 != null) {
                    if (throwable2 != null) {
                        try {
                            ((PrintStream)printStream3).close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                    } else {
                        ((PrintStream)printStream3).close();
                    }
                }
            }
        }
        List scalarCols = this.schema.entrySet().stream().filter(e -> Number.class.isAssignableFrom((Class)e.getValue())).collect(Collectors.toList());
        FileOutputStream file = new FileOutputStream(new File(path, "tensors.tsv"));
        printStream3 = null;
        try {
            printStream22 = new PrintStream(file);
            throwable = null;
            try {
                for (Map<CharSequence, Object> row : this.rows) {
                    ((PrintStream)printStream22).println(scalarCols.stream().map(e -> ((Number)row.getOrDefault(e.getKey(), 0)).doubleValue()).map(x -> x.toString()).collect(Collectors.joining("\t")));
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (printStream22 != null) {
                    if (throwable != null) {
                        try {
                            ((PrintStream)printStream22).close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        ((PrintStream)printStream22).close();
                    }
                }
            }
        }
        catch (Throwable printStream22) {
            printStream3 = printStream22;
            throw printStream22;
        }
        finally {
            if (file != null) {
                if (printStream3 != null) {
                    try {
                        file.close();
                    }
                    catch (Throwable printStream22) {
                        ((Throwable)printStream3).addSuppressed(printStream22);
                    }
                } else {
                    file.close();
                }
            }
        }
        List metadataCols = this.schema.entrySet().stream().filter(e -> String.class.isAssignableFrom((Class)e.getValue())).collect(Collectors.toList());
        FileOutputStream file2 = new FileOutputStream(new File(path, "metadata.tsv"));
        printStream22 = null;
        try {
            PrintStream printStream4 = new PrintStream(file2);
            Object object2 = null;
            try {
                if (1 < metadataCols.size()) {
                    printStream4.println(metadataCols.stream().map(e -> (CharSequence)e.getKey()).collect(Collectors.joining("\t")));
                }
                for (Map<CharSequence, Object> row : this.rows) {
                    printStream4.println(metadataCols.stream().map(e -> row.getOrDefault(e.getKey(), "")).collect(Collectors.joining("\t")));
                }
            }
            catch (Throwable throwable7) {
                object2 = throwable7;
                throw throwable7;
            }
            finally {
                if (printStream4 != null) {
                    if (object2 != null) {
                        try {
                            printStream4.close();
                        }
                        catch (Throwable throwable8) {
                            ((Throwable)object2).addSuppressed(throwable8);
                        }
                    } else {
                        printStream4.close();
                    }
                }
            }
        }
        catch (Throwable throwable9) {
            printStream22 = throwable9;
            throw throwable9;
        }
        finally {
            if (file2 != null) {
                if (printStream22 != null) {
                    try {
                        file2.close();
                    }
                    catch (Throwable throwable10) {
                        ((Throwable)printStream22).addSuppressed(throwable10);
                    }
                } else {
                    file2.close();
                }
            }
        }
        List urlCols = this.schema.entrySet().stream().filter(e -> URL.class.isAssignableFrom((Class)e.getValue())).collect(Collectors.toList());
        throwable = null;
        try (FileOutputStream file3 = new FileOutputStream(new File(path, "bookmarks.txt"));){
            printStream5 = new PrintStream(file3);
            object = null;
            try {
                for (Map<CharSequence, Object> row : this.rows) {
                    printStream5.println(urlCols.stream().map(e -> row.get(e.getKey()).toString()).collect(Collectors.joining("\t")));
                }
            }
            catch (Throwable throwable11) {
                object = throwable11;
                throw throwable11;
            }
            finally {
                if (printStream5 != null) {
                    if (object != null) {
                        try {
                            printStream5.close();
                        }
                        catch (Throwable throwable12) {
                            ((Throwable)object).addSuppressed(throwable12);
                        }
                    } else {
                        printStream5.close();
                    }
                }
            }
        }
        catch (Throwable printStream5) {
            throwable = printStream5;
            throw printStream5;
        }
        file3 = new FileOutputStream(new File(path, "config.json"));
        throwable = null;
        try {
            printStream5 = new PrintStream(file3);
            object = null;
            try {
                printStream5.println("{\n  \"embeddings\": [\n    {\n      \"tensorName\": \"" + path.getName() + "\",\n      \"tensorShape\": [\n        " + this.rows.size() + ",\n        " + scalarCols.size() + "\n      ],\n      \"tensorPath\": \"" + new URL(baseUrl, "tensors.tsv") + (0 == metadataCols.size() ? "" : "\",\n      \"metadataPath\": \"" + new URL(baseUrl, "metadata.tsv")) + "\"\n    }\n  ]\n}");
            }
            catch (Throwable throwable13) {
                object = throwable13;
                throw throwable13;
            }
            finally {
                if (printStream5 != null) {
                    if (object != null) {
                        try {
                            printStream5.close();
                        }
                        catch (Throwable throwable14) {
                            ((Throwable)object).addSuppressed(throwable14);
                        }
                    } else {
                        printStream5.close();
                    }
                }
            }
        }
        catch (Throwable printStream6) {
            throwable = printStream6;
            throw printStream6;
        }
        finally {
            if (file3 != null) {
                if (throwable != null) {
                    try {
                        file3.close();
                    }
                    catch (Throwable printStream6) {
                        throwable.addSuppressed(printStream6);
                    }
                } else {
                    file3.close();
                }
            }
        }
        if (0 < urlCols.size()) {
            file3 = new FileOutputStream(new File(path, "config_withLinks.json"));
            throwable = null;
            try {
                printStream5 = new PrintStream(file3);
                object = null;
                try {
                    printStream5.println("{\n  \"embeddings\": [\n    {\n      \"tensorName\": \"" + path.getName() + "\",\n      \"tensorShape\": [\n        " + this.rows.size() + ",\n        " + scalarCols.size() + "\n      ],\n      \"tensorPath\": \"" + new URL(baseUrl, "tensors.tsv") + (0 == metadataCols.size() ? "" : "\",\n      \"metadataPath\": \"" + new URL(baseUrl, "metadata.tsv")) + "\",\n      \"bookmarksPath\": \"" + new URL(baseUrl, "bookmarks.txt") + "\"\n    }\n  ]\n}");
                }
                catch (Throwable throwable15) {
                    object = throwable15;
                    throw throwable15;
                }
                finally {
                    if (printStream5 != null) {
                        if (object != null) {
                            try {
                                printStream5.close();
                            }
                            catch (Throwable throwable16) {
                                ((Throwable)object).addSuppressed(throwable16);
                            }
                        } else {
                            printStream5.close();
                        }
                    }
                }
            }
            catch (Throwable throwable17) {
                throwable = throwable17;
                throw throwable17;
            }
            finally {
                if (file3 != null) {
                    if (throwable != null) {
                        try {
                            file3.close();
                        }
                        catch (Throwable throwable18) {
                            throwable.addSuppressed(throwable18);
                        }
                    } else {
                        file3.close();
                    }
                }
            }
        }
    }
}

