/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.lang;

import com.simiacryptus.lang.UncheckedRunnable;
import com.simiacryptus.lang.UncheckedSupplier;
import java.lang.management.ManagementFactory;
import javax.annotation.Nonnull;

public class TimedResult<T> {
    public final T result;
    public final long timeNanos;
    public final long gcMs;

    public TimedResult(T result, long timeNanos, long gcMs) {
        this.result = result;
        this.timeNanos = timeNanos;
        this.gcMs = gcMs;
    }

    public static <T> TimedResult<T> time(@Nonnull UncheckedSupplier<T> fn) {
        long priorGcMs = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum();
        long start = System.nanoTime();
        T result = null;
        try {
            result = fn.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long wallClockTime = System.nanoTime() - start;
        long gcTime = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum() - priorGcMs;
        return new TimedResult<Object>(result, wallClockTime, gcTime);
    }

    public static <T> TimedResult<Void> time(@Nonnull UncheckedRunnable<T> fn) {
        long priorGcMs = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum();
        long start = System.nanoTime();
        try {
            fn.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long wallClockTime = System.nanoTime() - start;
        long gcTime = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum() - priorGcMs;
        return new TimedResult<Object>(null, wallClockTime, gcTime);
    }

    public double seconds() {
        return (double)this.timeNanos / 1.0E9;
    }

    public double gc_seconds() {
        return (double)this.gcMs / 1000.0;
    }
}

