/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class ArrayUtil {
    @Nonnull
    public static double[] add(@Nonnull double[] a, @Nonnull double[] b) {
        return ArrayUtil.op(a, b, (double x, double y) -> x + y);
    }

    public static List<double[]> add(@Nonnull List<double[]> a, @Nonnull List<double[]> b) {
        return ArrayUtil.op(a, b, (double x, double y) -> x + y);
    }

    public static double dot(@Nonnull double[] a, @Nonnull double[] b) {
        return ArrayUtil.sum(ArrayUtil.op(a, b, (double x, double y) -> x * y));
    }

    public static double dot(@Nonnull List<double[]> a, @Nonnull List<double[]> b) {
        return ArrayUtil.sum(ArrayUtil.multiply(a, b));
    }

    public static double magnitude(@Nonnull double[] a) {
        return Math.sqrt(ArrayUtil.dot(a, a));
    }

    public static double mean(@Nonnull double[] op) {
        return ArrayUtil.sum(op) / (double)op.length;
    }

    public static List<double[]> minus(@Nonnull List<double[]> a, @Nonnull List<double[]> b) {
        return ArrayUtil.op(a, b, (double x, double y) -> x - y);
    }

    @Nonnull
    public static double[] multiply(@Nonnull double[] a, double b) {
        return ArrayUtil.op(a, (double x) -> x * b);
    }

    @Nonnull
    public static double[] multiply(@Nonnull double[] a, @Nonnull double[] b) {
        return ArrayUtil.op(a, b, (double x, double y) -> x * y);
    }

    @Nonnull
    public static List<double[]> multiply(@Nonnull List<double[]> a, double b) {
        return ArrayUtil.op(a, (double x) -> x * b);
    }

    public static List<double[]> multiply(@Nonnull List<double[]> a, @Nonnull List<double[]> b) {
        return ArrayUtil.op(a, b, (double x, double y) -> x * y);
    }

    @Nonnull
    public static double[] op(@Nonnull double[] a, @Nonnull double[] b, @Nonnull DoubleBinaryOperator fn) {
        assert (a.length == b.length);
        double[] c = new double[a.length];
        for (int j = 0; j < a.length; ++j) {
            c[j] = fn.applyAsDouble(a[j], b[j]);
        }
        return c;
    }

    @Nonnull
    public static double[] op(@Nonnull double[] a, @Nonnull DoubleUnaryOperator fn) {
        double[] c = new double[a.length];
        for (int j = 0; j < a.length; ++j) {
            c[j] = fn.applyAsDouble(a[j]);
        }
        return c;
    }

    @Nonnull
    public static List<double[]> op(@Nonnull List<double[]> a, @Nonnull DoubleUnaryOperator fn) {
        ArrayList<double[]> list = new ArrayList<double[]>();
        for (int i = 0; i < a.size(); ++i) {
            double[] c = new double[a.get(i).length];
            for (int j = 0; j < a.get(i).length; ++j) {
                c[j] = fn.applyAsDouble(a.get(i)[j]);
            }
            list.add(c);
        }
        return list;
    }

    public static List<double[]> op(@Nonnull List<double[]> a, @Nonnull List<double[]> b, @Nonnull DoubleBinaryOperator fn) {
        assert (a.size() == b.size());
        return IntStream.range(0, a.size()).parallel().mapToObj(i -> {
            assert (((double[])a.get(i)).length == ((double[])b.get(i)).length);
            double[] c = new double[((double[])a.get(i)).length];
            for (int j = 0; j < ((double[])a.get(i)).length; ++j) {
                c[j] = fn.applyAsDouble(((double[])a.get(i))[j], ((double[])b.get(i))[j]);
            }
            return c;
        }).collect(Collectors.toList());
    }

    @Nonnull
    public static double[] subtract(@Nonnull double[] a, @Nonnull double[] b) {
        return ArrayUtil.op(a, b, (double x, double y) -> x - y);
    }

    public static double sum(@Nonnull double[] op) {
        return Arrays.stream(op).sum();
    }

    @Nonnull
    public static double[] sum(@Nonnull double[] a, double b) {
        return ArrayUtil.op(a, (double x) -> x + b);
    }

    public static double sum(@Nonnull List<double[]> a) {
        return ((Stream)a.stream().parallel()).mapToDouble(x -> Arrays.stream(x).sum()).sum();
    }
}

