/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;

public class JsonUtil {
    public static double[] getDoubleArray(@Nonnull JsonArray array) {
        return IntStream.range(0, array.size()).mapToDouble(i -> array.get(i).getAsDouble()).toArray();
    }

    @Nullable
    public static int[] getIntArray(@Nullable JsonArray array) {
        if (null == array) {
            return null;
        }
        return IntStream.range(0, array.size()).map(i -> array.get(i).getAsInt()).toArray();
    }

    @Nonnull
    public static JsonArray getJson(@Nonnull double[] kernelDims) {
        JsonArray array = new JsonArray();
        for (double k : kernelDims) {
            array.add((JsonElement)new JsonPrimitive((Number)k));
        }
        return array;
    }

    @Nonnull
    public static JsonArray getJson(@Nonnull int[] kernelDims) {
        JsonArray array = new JsonArray();
        for (int k : kernelDims) {
            array.add((JsonElement)new JsonPrimitive((Number)k));
        }
        return array;
    }

    public static CharSequence toJson(Object obj) {
        return JsonUtil.toJson(obj, JsonUtil.getMapper());
    }

    @Nonnull
    public static CharSequence toJson(Object obj, ObjectMapper objectMapper) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            objectMapper.writeValue((OutputStream)outputStream, obj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new String(outputStream.toByteArray(), Charset.forName("UTF-8"));
    }

    public static ObjectMapper getMapper() {
        ObjectMapper enable = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        return enable;
    }

    public static <T> T cache(File file, Class<T> clazz, Supplier<T> intializer) throws IOException {
        if (file.exists()) {
            return (T)JsonUtil.getMapper().readValue(FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset()), clazz);
        }
        T obj = intializer.get();
        FileUtils.write((File)file, (CharSequence)JsonUtil.toJson(obj), (Charset)Charset.defaultCharset());
        return obj;
    }

    public static int[] toIntArray(JsonArray array) {
        int[] ints = new int[array.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = array.get(i).getAsInt();
        }
        return ints;
    }

    public static JsonArray toIntArray(int[] array) {
        JsonArray jsonElements = new JsonArray();
        Arrays.stream(array).forEach(arg_0 -> ((JsonArray)jsonElements).add(arg_0));
        return jsonElements;
    }
}

