/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simiacryptus.util.io.BinaryChunkIterator;
import com.simiacryptus.util.io.TeeInputStream;
import com.simiacryptus.util.test.LabeledObject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import java.util.Spliterators;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class Util {
    public static final ThreadLocal<Random> R = new ThreadLocal<Random>(){
        public final Random r = new Random(System.nanoTime());

        @Override
        protected Random initialValue() {
            return new Random(this.r.nextLong());
        }
    };
    private static final AtomicInteger idcounter = new AtomicInteger(0);
    private static final String jvmId = UUID.randomUUID().toString();

    public static void add(@Nonnull DoubleSupplier f, @Nonnull double[] data) {
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] + f.getAsDouble();
        }
    }

    public static Stream<byte[]> binaryStream(String path, @Nonnull String name, int skip, int recordSize) throws IOException {
        File file = new File(path, name);
        byte[] fileData = IOUtils.toByteArray((InputStream)new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)))));
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(fileData));
        in.skip(skip);
        return Util.toIterator(new BinaryChunkIterator(in, recordSize));
    }

    public static <F, T> Function<F, T> cache(final @Nonnull Function<F, T> inner) {
        LoadingCache cache = CacheBuilder.newBuilder().build(new CacheLoader<F, T>(){

            public T load(F key) {
                return inner.apply(key);
            }
        });
        return arg_0 -> ((LoadingCache)cache).getUnchecked(arg_0);
    }

    public static InputStream cacheLocal(String file, URI url) throws IOException {
        return Util.cacheLocal(file, Util.getStreamSupplier(url));
    }

    public static InputStream cacheLocal(String file, Supplier<InputStream> fn) throws FileNotFoundException {
        File f = new File(file);
        if (f.exists()) {
            return new FileInputStream(f);
        }
        FileOutputStream cache = new FileOutputStream(file);
        return new TeeInputStream(fn.get(), cache);
    }

    public static Supplier<InputStream> getStreamSupplier(URI url) {
        return () -> {
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, trustManagers, null);
                SSLSocketFactory sslFactory = ctx.getSocketFactory();
                URLConnection urlConnection = url.toURL().openConnection();
                if (urlConnection instanceof HttpsURLConnection) {
                    HttpsURLConnection conn = (HttpsURLConnection)urlConnection;
                    conn.setSSLSocketFactory(sslFactory);
                    conn.setRequestMethod("GET");
                }
                return urlConnection.getInputStream();
            }
            catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static InputStream cacheStream(@Nonnull String url, @Nonnull String file) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        if (new File(file).exists()) {
            return new FileInputStream(file);
        }
        return new TeeInputStream(Util.get(url), new FileOutputStream(file));
    }

    public static File cacheFile(@Nonnull String url, @Nonnull String file) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        if (!new File(file).exists()) {
            IOUtils.copy((InputStream)Util.get(url), (OutputStream)new FileOutputStream(file));
        }
        return new File(file);
    }

    public static InputStream get(@Nonnull String url) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            @Nonnull
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, trustManagers, null);
        SSLSocketFactory sslFactory = ctx.getSocketFactory();
        URLConnection urlConnection = new URL(url).openConnection();
        if (urlConnection instanceof HttpsURLConnection) {
            HttpsURLConnection conn = (HttpsURLConnection)urlConnection;
            conn.setSSLSocketFactory(sslFactory);
            conn.setRequestMethod("GET");
        }
        return urlConnection.getInputStream();
    }

    public static InputStream cacheStream(@Nonnull URI url) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        return Util.cacheStream(url.toString(), new File(url.getPath()).getName());
    }

    public static File cacheFile(@Nonnull URI url) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        return Util.cacheFile(url.toString(), new File(url.getPath()).getName());
    }

    public static CharSequence[] currentStack() {
        return (CharSequence[])Stream.of(Thread.currentThread().getStackTrace()).map(Object::toString).toArray(CharSequence[]::new);
    }

    @Nonnull
    public static TemporalUnit cvt(@Nonnull TimeUnit units) {
        switch (units) {
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
        }
        throw new IllegalArgumentException(units.toString());
    }

    public static void layout(@Nonnull Component c) {
        c.doLayout();
        if (c instanceof Container) {
            Arrays.stream(((Container)c).getComponents()).forEach(Util::layout);
        }
    }

    public static String mkString(@Nonnull CharSequence separator, CharSequence ... strs) {
        return Arrays.asList(strs).stream().collect(Collectors.joining(separator));
    }

    public static String pathTo(@Nonnull File from, @Nonnull File to) {
        return from.toPath().relativize(to.toPath()).toString().replaceAll("\\\\", "/");
    }

    @Nonnull
    public static byte[] read(@Nonnull DataInputStream i, int s) throws IOException {
        int read;
        byte[] b = new byte[s];
        for (int pos = 0; b.length > pos; pos += read) {
            read = i.read(b, pos, b.length - pos);
            if (0 != read) continue;
            throw new RuntimeException();
        }
        return b;
    }

    @Nullable
    public static BufferedImage maximumSize(@Nullable BufferedImage image, int width) {
        if (null == image) {
            return image;
        }
        width = Math.min(image.getWidth(), width);
        if (width == image.getWidth()) {
            return image;
        }
        int height = image.getHeight() * width / image.getWidth();
        BufferedImage rerender = new BufferedImage(width, height, 2);
        Graphics gfx = rerender.getGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        ((Graphics2D)gfx).setRenderingHints(hints);
        gfx.drawImage(image, 0, 0, rerender.getWidth(), rerender.getHeight(), null);
        return rerender;
    }

    public static BufferedImage toImage(Component component) {
        if (null == component) {
            return null;
        }
        try {
            Util.layout(component);
            BufferedImage img = new BufferedImage(component.getWidth(), component.getHeight(), 1);
            Graphics2D g = img.createGraphics();
            g.setColor(component.getForeground());
            g.setFont(component.getFont());
            component.print(g);
            return img;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CharSequence toInlineImage(BufferedImage img, String alt) {
        return Util.toInlineImage(new LabeledObject<BufferedImage>(img, alt));
    }

    public static CharSequence toInlineImage(@Nonnull LabeledObject<BufferedImage> img) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img.data, "png", (OutputStream)b);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] byteArray = b.toByteArray();
        String encode = Base64.getEncoder().encodeToString(byteArray);
        return "<img src=\"data:image/png;base64," + encode + "\" alt=\"" + img.label + "\" />";
    }

    public static <T> Stream<T> toIterator(@Nonnull Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliterator(iterator, 1L, 16), false);
    }

    public static <T> Stream<T> toStream(@Nonnull Iterator<T> iterator) {
        return Util.toStream(iterator, 0);
    }

    public static <T> Stream<T> toStream(@Nonnull Iterator<T> iterator, int size) {
        return Util.toStream(iterator, size, false);
    }

    public static <T> Stream<T> toStream(@Nonnull Iterator<T> iterator, int size, boolean parallel) {
        return StreamSupport.stream(Spliterators.spliterator(iterator, (long)size, 16), parallel);
    }

    public static UUID uuid() {
        String index = Integer.toHexString(idcounter.incrementAndGet());
        while (index.length() < 8) {
            index = "0" + index;
        }
        String tempId = jvmId.substring(0, jvmId.length() - index.length()) + index;
        return UUID.fromString(tempId);
    }

    public static void sleep(int i) {
        try {
            Thread.sleep(i);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Nonnull
    public static String dateStr(String formatStr) {
        return new SimpleDateFormat(formatStr).format(new Date());
    }

    @Nonnull
    public static String stripPrefix(String str, String prefix) {
        while (str.startsWith(prefix)) {
            str = str.substring(prefix.length());
        }
        return str;
    }

    public static Path pathToFile(File baseFile, @Nonnull File file) {
        try {
            Path basePath = baseFile.getCanonicalFile().toPath().getParent();
            Path path = file.getCanonicalFile().toPath();
            return basePath.relativize(path);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Base: %s; File: %s", baseFile, file), e);
        }
    }

    @Nonnull
    public static String toString(Path path) {
        return path.normalize().toString().replaceAll("\\\\", "/");
    }

    public static void runAllParallel(Runnable ... runnables) {
        ((Stream)Arrays.stream(runnables).parallel()).forEach(Runnable::run);
    }

    public static void runAllSerial(Runnable ... runnables) {
        Arrays.stream(runnables).forEach(Runnable::run);
    }

    public static String toString(@Nonnull Consumer<PrintStream> fn) {
        java.io.ByteArrayOutputStream buffer = new java.io.ByteArrayOutputStream();
        try (PrintStream out = new PrintStream(buffer);){
            fn.accept(out);
        }
        return new String(buffer.toByteArray(), Charset.forName("UTF-8"));
    }

    public static String toString(StackTraceElement[] stack) {
        return Util.toString(stack, "\n");
    }

    public static String toString(StackTraceElement[] stack, CharSequence delimiter) {
        return Arrays.stream(stack).map(x -> x.getFileName() + ":" + x.getLineNumber()).reduce((a, b) -> a + delimiter + b).orElse("");
    }

    public static StackTraceElement[] getStackTrace() {
        return Util.getStackTrace(4);
    }

    public static StackTraceElement[] getStackTrace(int skip) {
        return (StackTraceElement[])Arrays.stream(Thread.currentThread().getStackTrace()).skip(skip).filter(x -> x.getClassName().startsWith("com.simiacryptus.")).limit(500L).toArray(StackTraceElement[]::new);
    }

    public static CharSequence getCaller() {
        return Util.toString(Util.getStackTrace(4));
    }

    public static float[] getFloats(double[] doubles) {
        float[] floats = new float[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            floats[i] = (float)doubles[i];
        }
        return floats;
    }

    public static double[] getDoubles(float[] floats) {
        double[] doubles = new double[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            doubles[i] = floats[i];
        }
        return doubles;
    }

    public static long[] toLong(int[] ints) {
        long[] longs = new long[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            longs[i] = ints[i];
        }
        return longs;
    }

    public static int[] toInt(long[] longs) {
        int[] ints = new int[longs.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = (int)longs[i];
        }
        return ints;
    }

    public static String toString(Throwable e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream printStream = new PrintStream((OutputStream)out);){
            e.printStackTrace(printStream);
        }
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }
}

