/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.binary.codes;

import com.simiacryptus.util.binary.BitInputStream;
import com.simiacryptus.util.binary.Bits;
import com.simiacryptus.util.binary.bitset.BitsCollection;
import com.simiacryptus.util.binary.bitset.CountTreeBitsCollection;
import com.simiacryptus.util.binary.codes.HammingSymbol;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class HammingCode<T extends Comparable<T>> {
    protected final TreeMap<Bits, T> forwardIndex = new TreeMap();
    protected final HashMap<T, Bits> reverseIndex = new HashMap();
    protected final HashMap<T, Integer> weights = new HashMap();
    protected final long totalWeight;

    public HammingCode(Collection<HammingSymbol<T>> symbols) {
        if (0 < symbols.size()) {
            TreeSet assemblySet = new TreeSet();
            for (HammingSymbol<T> s : symbols) {
                this.weights.put(s.key, s.count);
                assemblySet.add(new SubCode(s.count, s.key));
            }
            while (assemblySet.size() > 1) {
                SubCode zero = (SubCode)assemblySet.pollFirst();
                SubCode one = (SubCode)assemblySet.pollFirst();
                assemblySet.add(new SubCode(zero, one));
            }
            SubCode root = (SubCode)assemblySet.first();
            this.forwardIndex.putAll(root.codes);
            this.reverseIndex.putAll(root.index);
            this.totalWeight = root.count;
        } else {
            this.totalWeight = 0L;
        }
        assert (this.verifyIndexes());
        assert (this.forwardIndex.size() == symbols.size());
    }

    public static boolean isPrefixFreeCode(Set<Bits> keySet) {
        TreeSet<Bits> check = new TreeSet<Bits>();
        for (Bits code : keySet) {
            Bits ceiling = check.ceiling(code);
            if (null != ceiling && (ceiling.startsWith(code) || code.startsWith(ceiling))) {
                return false;
            }
            Bits floor = check.floor(code);
            if (null != floor && (floor.startsWith(code) || code.startsWith(floor))) {
                return false;
            }
            check.add(code);
        }
        return true;
    }

    public int codeSize() {
        return this.forwardIndex.size();
    }

    public T decode(BitInputStream in) throws IOException {
        Bits remainder = in.readAhead(0);
        Map.Entry<Bits, T> entry = this.forwardIndex.floorEntry(remainder);
        while (entry == null || !remainder.startsWith(entry.getKey())) {
            remainder = in.readAhead();
            entry = this.forwardIndex.floorEntry(remainder);
        }
        in.read(entry.getKey().bitLength);
        return (T)((Comparable)entry.getValue());
    }

    public Map.Entry<Bits, T> decode(Bits data) {
        if (null == data) {
            throw new IllegalArgumentException();
        }
        Map.Entry<Bits, T> entry = this.forwardIndex.floorEntry(data);
        if (entry != null && !data.startsWith(entry.getKey())) {
            entry = null;
        }
        return entry;
    }

    public Bits encode(T key) {
        Bits bits = this.reverseIndex.get(key);
        assert (null != bits || this.verifyIndexes());
        return bits;
    }

    public SortedMap<Bits, T> getCodes(Bits fromKey) {
        Bits next = fromKey.next();
        SortedMap<Bits, T> subMap = null == next ? this.forwardIndex.tailMap(fromKey) : this.forwardIndex.subMap(fromKey, next);
        return subMap;
    }

    public CountTreeBitsCollection getSetEncoder() {
        return new HammingCodeCollection();
    }

    public CountTreeBitsCollection getSetEncoder(BitInputStream data) throws IOException {
        return new HammingCodeCollection(data);
    }

    public CountTreeBitsCollection getSetEncoder(byte[] data) throws IOException {
        return new HammingCodeCollection(data);
    }

    public Map<T, Integer> getWeights() {
        return Collections.unmodifiableMap(this.weights);
    }

    public boolean verifyIndexes() {
        if (!HammingCode.isPrefixFreeCode(this.forwardIndex.keySet())) {
            return false;
        }
        for (Map.Entry<Bits, T> entry : this.forwardIndex.entrySet()) {
            if (!entry.getKey().equals(this.reverseIndex.get(entry.getValue()))) {
                return false;
            }
            if (((Comparable)entry.getValue()).equals(this.forwardIndex.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry<Bits, Object> entry : this.reverseIndex.entrySet()) {
            if (!((Comparable)entry.getKey()).equals(this.forwardIndex.get(entry.getValue()))) {
                return false;
            }
            if (((Bits)entry.getValue()).equals(this.reverseIndex.get(entry.getKey()))) continue;
            return false;
        }
        return this.reverseIndex.size() == this.forwardIndex.size();
    }

    public int totalWeight() {
        return 0;
    }

    public class HammingCodeCollection
    extends CountTreeBitsCollection {
        public HammingCodeCollection() {
        }

        public HammingCodeCollection(BitInputStream data) throws IOException {
            super(data);
        }

        public HammingCodeCollection(byte[] data) throws IOException {
            super(data);
        }

        @Override
        public BitsCollection.CodeType getType(Bits bits) {
            Map.Entry code = HammingCode.this.decode(bits);
            if (null == code) {
                return BitsCollection.CodeType.Prefix;
            }
            assert (bits.equals(code.getKey()));
            return BitsCollection.CodeType.Terminal;
        }
    }

    private static class SubCode<X extends Comparable<X>>
    implements Comparable<SubCode<X>> {
        final long count;
        final TreeMap<Bits, X> codes;
        final TreeMap<X, Bits> index;

        public SubCode(long count, X item) {
            this.count = count;
            this.codes = new TreeMap();
            this.index = new TreeMap();
            this.codes.put(Bits.NULL, item);
            this.index.put(item, Bits.NULL);
        }

        public SubCode(SubCode<X> zero, SubCode<X> one) {
            Bits code;
            this.count = zero.count + one.count;
            this.codes = new TreeMap();
            this.index = new TreeMap();
            for (Map.Entry<Bits, X> e : zero.codes.entrySet()) {
                assert (!one.index.containsKey(e.getValue()));
                code = Bits.ZERO.concatenate(e.getKey());
                this.assertNull(this.codes.put(code, e.getValue()));
                this.assertNull(this.index.put(e.getValue(), code));
            }
            for (Map.Entry<Bits, X> e : one.codes.entrySet()) {
                assert (!zero.index.containsKey(e.getValue()));
                code = Bits.ONE.concatenate(e.getKey());
                this.assertNull(this.codes.put(code, e.getValue()));
                this.assertNull(this.index.put(e.getValue(), code));
            }
        }

        private void assertNull(Object obj) {
            assert (null == obj);
        }

        @Override
        public int compareTo(SubCode<X> o) {
            if (this.count < o.count) {
                return -1;
            }
            if (this.count > o.count) {
                return 1;
            }
            int compareTo = ((Comparable)this.index.firstKey()).compareTo(o.index.firstKey());
            assert (0 != compareTo);
            return compareTo;
        }
    }
}

