/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.lang;

import com.simiacryptus.lang.UncheckedRunnable;
import com.simiacryptus.lang.UncheckedSupplier;
import com.simiacryptus.ref.lang.RefAware;
import com.simiacryptus.ref.lang.RefUtil;
import com.simiacryptus.ref.lang.ReferenceCountingBase;
import com.simiacryptus.ref.wrappers.RefSystem;
import com.simiacryptus.util.Util;
import java.lang.management.ManagementFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TimedResult<T>
extends ReferenceCountingBase {
    public final long timeNanos;
    public final long gcMs;
    private final T result;

    public TimedResult(T result, long timeNanos, long gcMs) {
        this.result = result;
        this.timeNanos = timeNanos;
        this.gcMs = gcMs;
    }

    @RefAware
    public T getResult() {
        return (T)RefUtil.addRef(this.result);
    }

    public static <T> @Nonnull TimedResult<T> time(@RefAware @Nonnull UncheckedSupplier<T> fn) {
        try {
            long priorGcMs = TimedResult.gcTime();
            long start = RefSystem.nanoTime();
            @Nullable T result = fn.get();
            TimedResult<T> timedResult = new TimedResult<T>(result, RefSystem.nanoTime() - start, TimedResult.gcTime() - priorGcMs);
            return timedResult;
        }
        catch (Exception e) {
            throw Util.throwException(e);
        }
        finally {
            RefUtil.freeRef(fn);
        }
    }

    public static long gcTime() {
        return ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum();
    }

    public static <T> @Nonnull TimedResult<Void> time(@RefAware @Nonnull UncheckedRunnable<T> fn) {
        try {
            long priorGcMs = TimedResult.gcTime();
            long start = RefSystem.nanoTime();
            fn.get();
            TimedResult<Object> timedResult = new TimedResult<Object>(null, RefSystem.nanoTime() - start, TimedResult.gcTime() - priorGcMs);
            return timedResult;
        }
        catch (Exception e) {
            throw Util.throwException(e);
        }
        finally {
            RefUtil.freeRef(fn);
        }
    }

    public double seconds() {
        return (double)this.timeNanos / 1.0E9;
    }

    public double gc_seconds() {
        return (double)this.gcMs / 1000.0;
    }

    protected void _free() {
        RefUtil.freeRef(this.result);
        super._free();
    }
}

