/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.simiacryptus.ref.wrappers.RefString;
import com.simiacryptus.util.JsonUtil;
import com.simiacryptus.util.Util;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalAppSettings {
    private static final Logger logger = LoggerFactory.getLogger(LocalAppSettings.class);
    public final Map<String, String> properties = new HashMap<String, String>();

    public LocalAppSettings(@Nonnull HashMap<String, String> properties) {
        this.properties.putAll(properties);
    }

    public static @Nullable HashMap<String, String> read() {
        return LocalAppSettings.read(new File("."));
    }

    public static @Nullable HashMap<String, String> read(@Nonnull File workingDir) {
        File parentFile = workingDir.getParentFile();
        File file = new File(workingDir, "app.json");
        if (file.exists()) {
            HashMap settings;
            try {
                settings = (HashMap)JsonUtil.getMapper().readValue(new String(FileUtils.readFileToByteArray((File)file), Charset.forName("UTF-8")), HashMap.class);
                settings.forEach((k, v) -> logger.info(RefString.format((String)"Loaded %s = %s from %s", (Object[])new Object[]{k, v, file})));
            }
            catch (IOException e) {
                throw Util.throwException(e);
            }
            if (parentFile != null && parentFile.exists()) {
                settings.putAll(LocalAppSettings.read(parentFile));
            }
            return settings;
        }
        if (parentFile != null && parentFile.exists()) {
            return LocalAppSettings.read(parentFile);
        }
        return new HashMap<String, String>();
    }
}

