/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.binary;

import com.simiacryptus.ref.wrappers.RefStringBuilder;
import com.simiacryptus.util.binary.Bits;
import javax.annotation.Nonnull;

public class Interval {
    public final long start;
    public final long max;
    public final long length;

    public Interval(long start, long length, long max) {
        if (0L >= max) {
            throw new IllegalArgumentException();
        }
        if (0L > start || max <= start) {
            throw new IllegalArgumentException();
        }
        if (0L >= length) {
            throw new IllegalArgumentException();
        }
        if (max < start + length) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.max = max;
        this.length = length;
    }

    public long end() {
        return this.start + this.length;
    }

    public @Nonnull Bits toBits() {
        int peekBits = (int)Math.ceil(Math.log(this.max) / Math.log(2.0)) + 4;
        Bits startBits = Bits.divide(this.start, this.max, peekBits).padRight(peekBits);
        Bits endBits = Bits.divide(this.end(), this.max, peekBits).padRight(peekBits);
        for (int i = 0; i < peekBits; ++i) {
            long a = startBits.range(0, i).toLong();
            long b = endBits.range(0, i).toLong();
            if (b - a <= 1L) continue;
            Bits bits = new Bits(a + 1L, i);
            assert (Bits.ZERO.equals(bits.range(0, 1)));
            return bits.range(1);
        }
        throw new RuntimeException();
    }

    public String toString() {
        RefStringBuilder sb = new RefStringBuilder((CharSequence)"Interval{");
        sb.append((CharSequence)"start=").append((Object)this.start);
        sb.append((CharSequence)", length=").append((Object)this.length);
        sb.append((CharSequence)", max=").append((Object)this.max);
        sb.append('}');
        return sb.toString();
    }
}

