/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.data;

import com.google.gson.JsonObject;
import com.simiacryptus.util.MonitoredItem;
import com.simiacryptus.util.data.PercentileStatistics;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScalarStatistics
implements MonitoredItem,
Serializable {
    private static final double zeroTol = 1.0E-20;
    private volatile double max = Double.NEGATIVE_INFINITY;
    private volatile double min = Double.POSITIVE_INFINITY;
    private volatile int negatives = 0;
    private volatile int positives = 0;
    private volatile int sum0 = 0;
    private volatile double sum1 = 0.0;
    private volatile double sum2 = 0.0;
    private volatile double sumLog = 0.0;
    private volatile int zeros = 0;

    public int getCount() {
        return this.sum0;
    }

    public @Nonnull JsonObject getJson() {
        @Nonnull JsonObject json = new JsonObject();
        json.addProperty("min", (Number)this.min);
        json.addProperty("max", (Number)this.max);
        json.addProperty("negatives", (Number)this.negatives);
        json.addProperty("positives", (Number)this.positives);
        json.addProperty("zeros", (Number)this.zeros);
        json.addProperty("sum0", (Number)this.sum0);
        json.addProperty("sum1", (Number)this.sum1);
        json.addProperty("sum2", (Number)this.sum2);
        json.addProperty("sumLog", (Number)this.sumLog);
        return json;
    }

    public double getMean() {
        return this.sum1 / (double)this.sum0;
    }

    public double getMeanPower() {
        return this.sumLog / (double)(this.sum0 - this.zeros);
    }

    @Override
    public Map<CharSequence, Object> getMetrics() {
        @Nonnull HashMap<CharSequence, Object> map = new HashMap<CharSequence, Object>();
        map.put("count", this.sum0);
        map.put("sum", this.sum1);
        map.put("negative", this.negatives);
        map.put("positive", this.positives);
        map.put("min", this.min);
        map.put("max", this.max);
        map.put("mean", this.getMean());
        map.put("stdDev", this.getStdDev());
        map.put("meanExponent", this.getMeanPower());
        map.put("zeros", this.zeros);
        return map;
    }

    public double getStdDev() {
        return Math.sqrt(Math.abs(Math.pow(this.getMean(), 2.0) - this.sum2 / (double)this.sum0));
    }

    public static @Nonnull ScalarStatistics stats(@Nonnull double[] data) {
        @Nonnull PercentileStatistics statistics = new PercentileStatistics();
        Arrays.stream(data).forEach(v -> statistics.add(v));
        return statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable ScalarStatistics add(double ... values) {
        double v1 = 0.0;
        double v2 = 0.0;
        double vmax = this.max;
        double vmin = this.min;
        int z = 0;
        double vlog = 0.0;
        int n = 0;
        int p = 0;
        for (double v : values) {
            v1 += v;
            v2 += v * v;
            vmin = Math.min(vmin, v);
            vmax = Math.max(vmax, v);
            if (Math.abs(v) < 1.0E-20) {
                ++z;
                continue;
            }
            if (v < 0.0) {
                ++n;
            } else {
                ++p;
            }
            vlog += Math.log10(Math.abs(v));
        }
        ScalarStatistics scalarStatistics = this;
        synchronized (scalarStatistics) {
            this.sum0 += values.length;
            this.sum1 += v1;
            this.sum2 += v2;
            this.min = Math.min(this.min, vmin);
            this.max = Math.max(this.max, vmax);
            this.negatives += n;
            this.positives += p;
            this.sumLog += vlog;
            this.zeros += z;
        }
        return this;
    }

    public final synchronized void add(double v) {
        ++this.sum0;
        this.sum1 += v;
        this.sum2 += v * v;
        this.min = Math.min(this.min, v);
        this.max = Math.max(this.max, v);
        if (Math.abs(v) < 1.0E-20) {
            ++this.zeros;
        } else {
            if (v < 0.0) {
                ++this.negatives;
            } else {
                ++this.positives;
            }
            this.sumLog += Math.log10(Math.abs(v));
        }
    }

    public final synchronized @Nonnull ScalarStatistics add(@Nonnull ScalarStatistics right) {
        @Nonnull ScalarStatistics sum = new ScalarStatistics();
        sum.sum0 += this.sum0;
        sum.sum0 += right.sum0;
        sum.sum1 += this.sum1;
        sum.sum1 += right.sum1;
        sum.sum2 += this.sum2;
        sum.sum2 += right.sum2;
        return sum;
    }

    public void clear() {
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        this.negatives = 0;
        this.positives = 0;
        this.zeros = 0;
        this.sum0 = 0;
        this.sum1 = 0.0;
        this.sum2 = 0.0;
        this.sumLog = 0.0;
    }

    public void readJson(@Nullable JsonObject json) {
        if (null == json) {
            return;
        }
        this.min = json.get("min").getAsDouble();
        this.max = json.get("max").getAsDouble();
        this.negatives = json.get("negatives").getAsInt();
        this.positives = json.get("positives").getAsInt();
        this.zeros = json.get("zeros").getAsInt();
        this.sum0 = json.get("sum0").getAsInt();
        this.sum1 = json.get("sum1").getAsDouble();
        this.sum2 = json.get("sum2").getAsDouble();
        this.sumLog = json.get("sumLog").getAsDouble();
    }

    public final synchronized @Nonnull ScalarStatistics subtract(@Nonnull ScalarStatistics right) {
        @Nonnull ScalarStatistics sum = new ScalarStatistics();
        sum.sum0 += this.sum0;
        sum.sum0 -= right.sum0;
        sum.sum1 += this.sum1;
        sum.sum1 -= right.sum1;
        sum.sum2 += this.sum2;
        sum.sum2 -= right.sum2;
        return sum;
    }

    public String toString() {
        return this.getMetrics().toString();
    }
}

