/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.simiacryptus.util.io.AsyncOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TeeOutputStream
extends OutputStream {
    public final List<OutputStream> branches = new ArrayList<OutputStream>();
    public final OutputStream primary;
    private final @Nullable ByteArrayOutputStream heapBuffer;
    private boolean chainCloses;

    public TeeOutputStream(OutputStream primary, boolean buffer) {
        this.setChainCloses(false);
        this.primary = primary;
        if (buffer) {
            this.heapBuffer = new ByteArrayOutputStream();
            this.branches.add(this.heapBuffer);
        } else {
            this.heapBuffer = null;
        }
    }

    public TeeOutputStream(OutputStream primary, OutputStream ... secondaries) {
        this(primary, false);
        this.branches.addAll(Arrays.asList(secondaries));
    }

    public boolean isChainCloses() {
        return this.chainCloses;
    }

    public @Nonnull TeeOutputStream setChainCloses(boolean chainCloses) {
        this.chainCloses = chainCloses;
        return this;
    }

    @Override
    public void close() throws IOException {
        this.primary.close();
        if (this.isChainCloses()) {
            for (OutputStream branch : this.branches) {
                branch.close();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.primary.flush();
        for (OutputStream branch : this.branches) {
            branch.flush();
        }
    }

    public @Nonnull PipedInputStream newInputStream() throws IOException {
        @Nonnull TeeOutputStream outTee = this;
        @Nonnull AtomicReference<Runnable> onClose = new AtomicReference<Runnable>();
        final @Nonnull PipedOutputStream outPipe = new PipedOutputStream();
        @Nonnull PipedInputStream in = new PipedInputStream(){

            @Override
            public void close() throws IOException {
                outPipe.close();
                super.close();
            }
        };
        outPipe.connect(in);
        @Nonnull AsyncOutputStream outAsync = new AsyncOutputStream(outPipe);
        new Thread(() -> {
            try {
                if (null != this.heapBuffer) {
                    outAsync.write(this.heapBuffer.toByteArray());
                    outAsync.flush();
                }
                outTee.branches.add(outAsync);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
        onClose.set(() -> {
            outTee.branches.remove(outAsync);
            System.err.println("END HTTP Session");
        });
        return in;
    }

    @Override
    public synchronized void write(@Nonnull byte[] b) throws IOException {
        this.primary.write(b);
        for (OutputStream branch : this.branches) {
            branch.write(b);
        }
    }

    @Override
    public synchronized void write(@Nonnull byte[] b, int off, int len) throws IOException {
        this.primary.write(b, off, len);
        for (OutputStream branch : this.branches) {
            branch.write(b, off, len);
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.primary.write(b);
        for (OutputStream branch : this.branches) {
            branch.write(b);
        }
    }
}

