/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.simiacryptus.ref.lang.RefAware;
import com.simiacryptus.ref.lang.RefUtil;
import com.simiacryptus.ref.wrappers.RefArrayList;
import com.simiacryptus.ref.wrappers.RefArrays;
import com.simiacryptus.ref.wrappers.RefCollectors;
import com.simiacryptus.ref.wrappers.RefIntStream;
import com.simiacryptus.ref.wrappers.RefList;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntFunction;
import java.util.stream.Collector;
import javax.annotation.Nonnull;

public class ArrayUtil {
    public static @Nonnull double[] add(@Nonnull double[] a, @Nonnull double[] b) {
        return ArrayUtil.op(a, b, (double x, double y) -> x + y);
    }

    public static RefList<double[]> add(@Nonnull RefList<double[]> a, @Nonnull RefList<double[]> b) {
        return ArrayUtil.op(a, b, (double x, double y) -> x + y);
    }

    public static double dot(@Nonnull double[] a, @Nonnull double[] b) {
        return ArrayUtil.sum(ArrayUtil.op(a, b, (double x, double y) -> x * y));
    }

    public static double dot(@Nonnull RefList<double[]> a, @Nonnull RefList<double[]> b) {
        return ArrayUtil.sum(ArrayUtil.multiply(a, b));
    }

    public static double magnitude(@Nonnull double[] a) {
        return Math.sqrt(ArrayUtil.dot(a, a));
    }

    public static double mean(@Nonnull double[] op) {
        return ArrayUtil.sum(op) / (double)op.length;
    }

    public static RefList<double[]> minus(@Nonnull RefList<double[]> a, @Nonnull RefList<double[]> b) {
        return ArrayUtil.op(a, b, (double x, double y) -> x - y);
    }

    public static @Nonnull double[] multiply(@Nonnull double[] a, double b) {
        return ArrayUtil.op(a, (double x) -> x * b);
    }

    public static @Nonnull double[] multiply(@Nonnull double[] a, @Nonnull double[] b) {
        return ArrayUtil.op(a, b, (double x, double y) -> x * y);
    }

    public static @Nonnull RefList<double[]> multiply(@Nonnull RefList<double[]> a, double b) {
        return ArrayUtil.op(a, (double x) -> x * b);
    }

    public static RefList<double[]> multiply(@RefAware @Nonnull RefList<double[]> a, @RefAware @Nonnull RefList<double[]> b) {
        return ArrayUtil.op(a, b, (double x, double y) -> x * y);
    }

    public static @Nonnull double[] op(@Nonnull double[] a, @Nonnull double[] b, @Nonnull DoubleBinaryOperator fn) {
        assert (a.length == b.length);
        @Nonnull double[] c = new double[a.length];
        for (int j = 0; j < a.length; ++j) {
            c[j] = fn.applyAsDouble(a[j], b[j]);
        }
        return c;
    }

    public static @Nonnull double[] op(@Nonnull double[] a, @Nonnull DoubleUnaryOperator fn) {
        @Nonnull double[] c = new double[a.length];
        for (int j = 0; j < a.length; ++j) {
            c[j] = fn.applyAsDouble(a[j]);
        }
        return c;
    }

    public static @Nonnull RefList<double[]> op(@RefAware @Nonnull RefList<double[]> a, @Nonnull DoubleUnaryOperator fn) {
        @Nonnull RefArrayList list = new RefArrayList();
        for (int i = 0; i < a.size(); ++i) {
            double[] doubles = (double[])a.get(i);
            @Nonnull double[] c = new double[doubles.length];
            for (int j = 0; j < doubles.length; ++j) {
                c[j] = fn.applyAsDouble(doubles[j]);
            }
            list.add((Object)c);
        }
        a.freeRef();
        return list;
    }

    public static RefList<double[]> op(@RefAware @Nonnull RefList<double[]> a, @RefAware @Nonnull RefList<double[]> b, @Nonnull DoubleBinaryOperator fn) {
        assert (a.size() == b.size());
        return (RefList)RefIntStream.range((int)0, (int)a.size()).parallel().mapToObj((IntFunction)RefUtil.wrapInterface(i -> {
            double[] doubles_a = (double[])a.get(i);
            double[] doubles_b = (double[])b.get(i);
            assert (doubles_a.length == doubles_b.length);
            @Nonnull double[] c = new double[doubles_a.length];
            for (int j = 0; j < doubles_a.length; ++j) {
                c[j] = fn.applyAsDouble(doubles_a[j], doubles_b[j]);
            }
            return c;
        }, (Object[])new Object[]{a, b})).collect((Collector)RefCollectors.toList());
    }

    public static @Nonnull double[] subtract(@Nonnull double[] a, @Nonnull double[] b) {
        return ArrayUtil.op(a, b, (double x, double y) -> x - y);
    }

    public static double sum(@Nonnull double[] op) {
        return RefArrays.stream((double[])op).sum();
    }

    public static @Nonnull double[] sum(@Nonnull double[] a, double b) {
        return ArrayUtil.op(a, (double x) -> x + b);
    }

    public static double sum(@RefAware @Nonnull RefList<double[]> a) {
        double temp_08_0007 = a.stream().parallel().mapToDouble(x -> RefArrays.stream((double[])x).sum()).sum();
        a.freeRef();
        return temp_08_0007;
    }
}

