/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.binary;

import com.simiacryptus.ref.wrappers.RefArrays;
import com.simiacryptus.ref.wrappers.RefConsumer;
import com.simiacryptus.util.Util;
import com.simiacryptus.util.binary.Bits;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public class BitOutputStream
implements AutoCloseable {
    static final int[] varLongDepths = new int[]{6, 14, 30, 62};
    private final OutputStream inner;
    private @Nonnull Bits remainder = Bits.NULL;
    private int totalBitsWritten = 0;

    public BitOutputStream(OutputStream inner) {
        this.inner = inner;
    }

    public int getTotalBitsWritten() {
        return this.totalBitsWritten;
    }

    public static @Nonnull Bits toBits(@Nonnull RefConsumer<BitOutputStream> fn) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            BitOutputStream out = new BitOutputStream(buffer);
            fn.accept((Object)out);
            out.flush();
            return new Bits(buffer.toByteArray(), out.getTotalBitsWritten());
        }
        catch (IOException e) {
            throw Util.throwException(e);
        }
    }

    public synchronized void flush() throws IOException {
        this.inner.write(this.remainder.getBytes());
        this.inner.flush();
        this.remainder = Bits.NULL;
    }

    public synchronized void write(@Nonnull Bits bits) throws IOException {
        Bits newRemainder = this.remainder.concatenate(bits);
        int newRemainingBits = newRemainder.bitLength % 8;
        int bitsToWrite = newRemainder.bitLength - newRemainingBits;
        if (bitsToWrite > 0) {
            assert (0 == bitsToWrite % 8);
            Bits toWrite = newRemainder.range(0, bitsToWrite);
            this.inner.write(toWrite.getBytes());
            newRemainder = newRemainder.range(bitsToWrite);
        }
        this.remainder = newRemainder;
        this.totalBitsWritten += bits.bitLength;
    }

    public void write(boolean b) throws IOException {
        this.write(new Bits(b ? 1L : 0L, 1));
    }

    public void write(double value) throws IOException {
        this.write(new Bits(Double.doubleToLongBits(value), 64));
    }

    public <T extends Enum<T>> void write(@Nonnull Enum<T> value) throws IOException {
        long ordinal = value.ordinal();
        this.write(new Bits(ordinal, 8));
    }

    public void write(short value) throws IOException {
        this.write(new Bits(value, 16));
    }

    public void write(char value) throws IOException {
        this.write(new Bits(value, 16));
    }

    public void write(int value) throws IOException {
        this.write(new Bits(value, 32));
    }

    public @Nonnull Bits writeBoundedLong(long value, long max) throws IOException {
        int bits;
        int n = bits = 0L >= max ? 0 : (int)(Math.floor(Math.log(max) / Math.log(2.0)) + 1.0);
        if (0 < bits) {
            Bits toWrite = new Bits(value, bits);
            this.write(toWrite);
            return toWrite;
        }
        return Bits.NULL;
    }

    public void writeVarLong(long value) throws IOException {
        int bitLength = new Bits((long)value).bitLength;
        int type = RefArrays.binarySearch((int[])varLongDepths, (int)bitLength);
        if (type < 0) {
            type = -type - 1;
        }
        this.write(new Bits(type, 2));
        this.write(new Bits(value, varLongDepths[type]));
    }

    public void writeVarShort(short value) throws IOException {
        this.writeVarShort(value, 7);
    }

    public void writeVarShort(short value, int optimal) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
        int[] varShortDepths = new int[]{optimal, 16};
        int bitLength = new Bits((long)((long)value)).bitLength;
        int type = RefArrays.binarySearch((int[])varShortDepths, (int)bitLength);
        if (type < 0) {
            type = -type - 1;
        }
        this.write(new Bits(type, 1));
        this.write(new Bits(value, varShortDepths[type]));
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.inner.close();
    }
}

