/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.binary.bitset;

import com.simiacryptus.ref.lang.RefUtil;
import com.simiacryptus.ref.wrappers.RefHashMap;
import com.simiacryptus.ref.wrappers.RefHashSet;
import com.simiacryptus.ref.wrappers.RefList;
import com.simiacryptus.util.Util;
import com.simiacryptus.util.binary.BitInputStream;
import com.simiacryptus.util.binary.BitOutputStream;
import com.simiacryptus.util.binary.Bits;
import com.simiacryptus.util.binary.bitset.BitsCollection;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public class RunLengthBitsCollection
extends BitsCollection<RefHashMap<Bits, AtomicInteger>> {
    public RunLengthBitsCollection(int bitDepth) {
        super(bitDepth, new RefHashMap());
    }

    @Override
    public void read(@Nonnull BitInputStream in) throws IOException {
        int size = (int)in.read(32).toLong();
        for (int i = 0; i < size; ++i) {
            Bits bits = in.read(this.bitDepth);
            int count = (int)in.read(32).toLong();
            assert (this.map != null);
            RefUtil.freeRef((Object)((RefHashMap)this.map).put((Object)bits, (Object)new AtomicInteger(count)));
        }
    }

    @Override
    public void write(@Nonnull BitOutputStream out) throws IOException {
        RefList temp_12_0001 = this.getList();
        out.write(new Bits(temp_12_0001.size(), 32));
        temp_12_0001.freeRef();
        assert (this.map != null);
        RefHashSet entries = ((RefHashMap)this.map).entrySet();
        entries.forEach(e -> {
            try {
                out.write((Bits)e.getKey());
                out.write(new Bits(((AtomicInteger)e.getValue()).get(), 32));
            }
            catch (IOException ex) {
                throw Util.throwException(ex);
            }
            finally {
                RefUtil.freeRef((Object)e);
            }
        });
        entries.freeRef();
    }

    @Override
    public void _free() {
        super._free();
    }

    @Override
    public @Nonnull RunLengthBitsCollection addRef() {
        return (RunLengthBitsCollection)super.addRef();
    }
}

