/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.simiacryptus.ref.wrappers.RefIteratorBase;
import com.simiacryptus.ref.wrappers.RefList;
import com.simiacryptus.util.Util;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AsyncListIterator<T>
extends RefIteratorBase<T> {
    private final @Nullable RefList<T> queue;
    private final Thread thread;
    int index = -1;

    public AsyncListIterator(@Nullable RefList<T> queue, Thread thread) {
        this.thread = thread;
        this.queue = queue;
    }

    public boolean hasNext() {
        assert (this.queue != null);
        return this.index < this.queue.size() || this.thread.isAlive();
    }

    public @Nullable T next() {
        try {
            while (this.hasNext()) {
                assert (this.queue != null);
                if (++this.index < this.queue.size()) {
                    return (T)this.queue.get(this.index);
                }
                Thread.sleep(100L);
            }
            return null;
        }
        catch (InterruptedException e) {
            throw Util.throwException(e);
        }
    }

    public void _free() {
        super._free();
        if (null != this.queue) {
            this.queue.freeRef();
        }
    }

    public @Nonnull AsyncListIterator<T> addRef() {
        return (AsyncListIterator)super.addRef();
    }
}

