/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata.process;

import com.simtechdata.process.ByteArrayConsumptionThread;
import com.simtechdata.process.EventSink;
import com.simtechdata.process.ExecutionEvent;
import com.simtechdata.process.ExternalProcessFailureException;
import com.simtechdata.process.IoHandler;
import com.simtechdata.process.OutputConsumptionThread;
import com.simtechdata.process.StartupException;
import com.simtechdata.process.StreamConsumer;
import com.simtechdata.process.StreamConsumerConsumptionThread;
import com.simtechdata.process.StreamCopyConsumptionThread;
import com.simtechdata.process.TimeoutException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Proc
implements EventSink {
    private final Process process;
    private int exitValue;
    private final long executionTime;
    private final OutputConsumptionThread err;
    private final String command;
    private final List<String> args;
    private final Long timeout;
    private final BlockingQueue<ExecutionEvent> eventQueue = new LinkedBlockingQueue<ExecutionEvent>();
    private final IoHandler ioHandler;

    public Proc(String command, List<String> args, Map<String, String> env, boolean clearEnvironment, InputStream stdin, Object stdout, File directory, Long timeout, Object stderr) throws StartupException, ExternalProcessFailureException {
        this.command = command;
        this.args = args;
        this.timeout = timeout;
        String[] cmdArray = this.concatenateCmdArgs();
        long t1 = System.currentTimeMillis();
        try {
            ProcessBuilder builder = new ProcessBuilder(cmdArray).directory(directory);
            if (clearEnvironment) {
                builder.environment().clear();
            }
            builder.environment().putAll(env);
            this.process = builder.start();
            OutputConsumptionThread stdoutConsumer = this.createStreamConsumer(stdout);
            this.err = stderr == null ? new ByteArrayConsumptionThread(this) : this.createStreamConsumer(stderr);
            this.ioHandler = new IoHandler(stdin, stdoutConsumer, this.err, this.process);
        }
        catch (IOException e) {
            throw new StartupException("Could not startup process '" + this + "'.", e);
        }
        try {
            List<Throwable> exceptions;
            ExecutionEvent nextEvent;
            this.startControlThread();
            ExecutionEvent executionEvent = nextEvent = timeout == null ? this.eventQueue.poll(Integer.MAX_VALUE, TimeUnit.HOURS) : this.eventQueue.poll(timeout, TimeUnit.MILLISECONDS);
            if (nextEvent == null) {
                this.killCleanUpAndThrowTimeoutException();
            }
            if (nextEvent != ExecutionEvent.PROCESS_EXITED) {
                if (nextEvent == ExecutionEvent.EXCEPTION_IN_STREAM_HANDLING) {
                    this.killProcessCleanup();
                } else {
                    throw new RuntimeException("Felix reckons we should never reach this point");
                }
            }
            if (!(exceptions = this.ioHandler.joinConsumption()).isEmpty()) {
                throw new IllegalStateException("Exception in stream consumption", exceptions.get(0));
            }
            this.executionTime = System.currentTimeMillis() - t1;
        }
        catch (InterruptedException e) {
            this.killProcessCleanup();
            throw new RuntimeException("Control Thread was interrupted killed process.", e);
        }
    }

    private OutputConsumptionThread createStreamConsumer(Object stream) {
        if (stream instanceof OutputStream) {
            return new StreamCopyConsumptionThread((OutputStream)stream, this);
        }
        if (stream instanceof StreamConsumer) {
            return new StreamConsumerConsumptionThread(this, (StreamConsumer)stream);
        }
        throw new RuntimeException("Badness, badness");
    }

    byte[] getErrorBytes() {
        if (this.err instanceof ByteArrayConsumptionThread) {
            return ((ByteArrayConsumptionThread)this.err).getBytes();
        }
        return null;
    }

    public String getErrorString() {
        byte[] bytes = this.getErrorBytes();
        return bytes != null ? new String(bytes, StandardCharsets.UTF_8) : null;
    }

    private void startControlThread() {
        new Thread(() -> {
            try {
                this.exitValue = this.process.waitFor();
                this.dispatch(ExecutionEvent.PROCESS_EXITED);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("", e);
            }
        }).start();
    }

    private void killCleanUpAndThrowTimeoutException() {
        this.process.destroy();
        this.ioHandler.cancelConsumption();
        throw new TimeoutException(this.toString(), this.timeout);
    }

    private void killProcessCleanup() {
        this.process.destroy();
        this.ioHandler.cancelConsumption();
    }

    @Override
    public void dispatch(ExecutionEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("${END}", e);
        }
    }

    private String[] concatenateCmdArgs() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.command);
        cmd.addAll(this.args);
        return cmd.toArray(new String[0]);
    }

    public String toString() {
        return Proc.formatCommandLine(this.command, this.args);
    }

    static String formatCommandLine(String command, List<String> args) {
        return command + " " + Proc.argsString(args);
    }

    private static String argsString(List<String> args) {
        StringBuilder temp = new StringBuilder();
        Iterator<String> stringIterator = args.iterator();
        while (stringIterator.hasNext()) {
            String arg = stringIterator.next();
            String escapedArg = Proc.naiveShellEscape(arg);
            temp.append(escapedArg);
            if (!stringIterator.hasNext()) continue;
            temp.append(" ");
        }
        return temp.toString();
    }

    private static String naiveShellEscape(String arg) {
        Pattern p = Pattern.compile("\\s");
        Matcher m = p.matcher(arg);
        Object escapedArg = m.find() ? "'" + arg.replaceAll("'", "'\"'\"'") + "'" : arg;
        return escapedArg;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }
}

