/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata.process;

import com.simtechdata.process.ExternalProcessFailureException;
import com.simtechdata.process.Helper;
import com.simtechdata.process.Proc;
import com.simtechdata.process.ProcResult;
import com.simtechdata.process.StartupException;
import com.simtechdata.process.StreamConsumer;
import com.simtechdata.process.TimeoutException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProcBuilder {
    private ByteArrayOutputStream defaultStdout = new ByteArrayOutputStream();
    private final String command;
    private final List<String> args = new ArrayList<String>();
    private final Map<String, String> env = new HashMap<String, String>();
    private OutputStream stdout = this.defaultStdout;
    private InputStream stdin;
    private OutputStream stderr;
    private Long timoutMillis = 5000L;
    private Set<Integer> expectedExitStatuses = new HashSet<Integer>(){
        {
            this.add(0);
        }
    };
    private File directory;
    private StreamConsumer outputConsumer;
    private StreamConsumer errorConsumer;
    private boolean clearEnvironment;

    public ProcBuilder(String command, String ... args) {
        this.command = command;
        this.withArgs(args);
    }

    public ProcBuilder withArg(String arg) {
        this.args.add(arg);
        return this;
    }

    public ProcBuilder withOutputStream(OutputStream stdout) {
        if (this.outputConsumer != null) {
            throw new IllegalArgumentException("`withOutputStream(OutputStream)` and `withOutputConsumer(OutputConsumer)` are mutually exclusive.");
        }
        this.stdout = stdout;
        return this;
    }

    public ProcBuilder withErrorStream(OutputStream stderr) {
        if (this.errorConsumer != null) {
            throw new IllegalArgumentException("`withErrorStream(OutputStream)` and `withErrorConsumer(OutputConsumer)` are mutually exclusive.");
        }
        this.stderr = stderr;
        return this;
    }

    public ProcBuilder withTimeoutMillis(long timeoutMillis) {
        this.timoutMillis = timeoutMillis;
        return this;
    }

    public ProcBuilder withNoTimeout() {
        this.timoutMillis = null;
        return this;
    }

    public ProcBuilder withInputStream(InputStream stdin) {
        this.stdin = stdin;
        return this;
    }

    public ProcBuilder withInput(String input) {
        this.stdin = new ByteArrayInputStream(input.getBytes());
        return this;
    }

    public ProcBuilder withInput(byte[] input) {
        this.stdin = new ByteArrayInputStream(input);
        return this;
    }

    public ProcBuilder withWorkingDirectory(File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("File '" + directory.getPath() + "' is not a directory.");
        }
        this.directory = directory;
        return this;
    }

    public ProcBuilder withArgs(String ... args) {
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    public ProcBuilder withExitStatuses(int[] exitstatuses) {
        this.expectedExitStatuses = Helper.asSet(exitstatuses);
        return this;
    }

    public ProcBuilder withExpectedExitStatuses(Set<Integer> expectedExitStatuses) {
        this.expectedExitStatuses = expectedExitStatuses;
        return this;
    }

    public ProcBuilder withExpectedExitStatuses(int ... expectedExitStatuses) {
        this.expectedExitStatuses = Helper.asSet(expectedExitStatuses);
        return this;
    }

    public ProcBuilder ignoreExitStatus() {
        this.expectedExitStatuses = Collections.emptySet();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcResult run() throws StartupException, TimeoutException, ExternalProcessFailureException {
        if (this.stdout != this.defaultStdout && this.outputConsumer != null) {
            throw new IllegalArgumentException("`withOutputStream(OutputStream)` and `withOutputConsumer(OutputConsumer)` are mutually exclusive.");
        }
        if (this.stderr != null && this.errorConsumer != null) {
            throw new IllegalArgumentException("`withErrorStream(OutputStream)` and `withErrorConsumer(OutputConsumer)` are mutually exclusive.");
        }
        try {
            ByteArrayOutputStream output;
            Proc proc = new Proc(this.command, this.args, this.env, this.clearEnvironment, this.stdin, this.outputConsumer != null ? this.outputConsumer : this.stdout, this.directory, this.timoutMillis, this.errorConsumer != null ? this.errorConsumer : this.stderr);
            ByteArrayOutputStream byteArrayOutputStream = output = this.defaultStdout == this.stdout && this.outputConsumer == null ? this.defaultStdout : null;
            if (!this.expectedExitStatuses.isEmpty() && !this.expectedExitStatuses.contains(proc.getExitValue())) {
                throw new ExternalProcessFailureException(this.command, proc.toString(), proc.getExitValue(), proc.getErrorString(), output, proc.getExecutionTime());
            }
            ProcResult procResult = new ProcResult(proc.toString(), output, proc.getExitValue(), proc.getExecutionTime(), proc.getErrorBytes());
            return procResult;
        }
        finally {
            this.defaultStdout = new ByteArrayOutputStream();
            this.stdout = this.defaultStdout;
            this.stdin = null;
        }
    }

    public static String run(String cmd, String ... args) {
        ProcBuilder builder = new ProcBuilder(cmd, new String[0]).withArgs(args);
        return builder.run().getOutputString();
    }

    public static String filter(String input, String cmd, String ... args) {
        ProcBuilder builder = new ProcBuilder(cmd, new String[0]).withArgs(args).withInput(input);
        return builder.run().getOutputString();
    }

    public ProcBuilder clearEnvironment() {
        this.clearEnvironment = true;
        return this;
    }

    public ProcBuilder withVar(String var, String value) {
        this.env.put(var, value);
        return this;
    }

    public ProcBuilder withVars(Map<String, String> vars) {
        this.env.putAll(vars);
        return this;
    }

    public ProcBuilder withOutputConsumer(StreamConsumer outputConsumer) {
        if (this.stdout != this.defaultStdout) {
            throw new IllegalArgumentException("`withOutputStream(OutputStream)` and `withOutputConsumer(OutputConsumer)` are mutually exclusive.");
        }
        this.outputConsumer = outputConsumer;
        return this;
    }

    public ProcBuilder withErrorConsumer(StreamConsumer errorConsumer) {
        if (this.stderr != null) {
            throw new IllegalArgumentException("`withErrorStream(OutputStream)` and `withErrorConsumer(OutputConsumer)` are mutually exclusive.");
        }
        this.errorConsumer = errorConsumer;
        return this;
    }

    @Deprecated
    public String getProcString() {
        return Proc.formatCommandLine(this.command, this.args);
    }

    public String getCommandLine() {
        return Proc.formatCommandLine(this.command, this.args);
    }
}

