/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata.process;

import com.simtechdata.process.EventSink;
import com.simtechdata.process.ExecutionEvent;
import com.simtechdata.process.OutputConsumptionThread;
import com.simtechdata.process.StreamCopyRunner;
import java.io.InputStream;
import java.io.OutputStream;

class StreamCopyConsumptionThread
implements OutputConsumptionThread {
    private final OutputStream stdout;
    private Thread thread;
    private Throwable throwable;
    private final EventSink eventSink;

    public StreamCopyConsumptionThread(OutputStream stdout, EventSink eventSink) {
        this.stdout = stdout;
        this.eventSink = eventSink;
    }

    @Override
    public void startConsumption(InputStream inputStream) {
        this.thread = new Thread(() -> {
            block2: {
                try {
                    new StreamCopyRunner(inputStream, this.stdout, false).run();
                }
                catch (Throwable t) {
                    if (this.thread.isInterrupted()) break block2;
                    this.throwable = t;
                    this.eventSink.dispatch(ExecutionEvent.EXCEPTION_IN_STREAM_HANDLING);
                }
            }
        });
        this.thread.start();
    }

    @Override
    public void join() throws InterruptedException {
        this.thread.join();
    }

    @Override
    public void interrupt() {
        this.thread.interrupt();
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }
}

