/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.client;

import com.solidfire.jsvcgen.client.RequestDispatcher;
import com.solidfire.jsvcgen.client.VersioningUtils;
import com.solidfire.jsvcgen.javautil.Consumer;
import com.solidfire.jsvcgen.javautil.Optional;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import net.iharder.Base64;

public class HttpsRequestDispatcher
implements RequestDispatcher {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    public static final int DEFAULT_READ_TIMEOUT = 60000;
    private final URL endpoint;
    private final Optional<String> authenticationToken;
    private final String endpointVersion;
    private int connectionTimeout;
    private int readTimeout;

    private HttpsRequestDispatcher(URL uRL, Optional<String> optional) {
        if (!uRL.getProtocol().equals("https")) {
            throw new IllegalArgumentException("Unsupported endpoint protocol \"" + uRL.getProtocol() + "\"." + "Only \"https\" is supported.");
        }
        this.endpointVersion = VersioningUtils.getVersionFromEndpoint(uRL);
        this.endpoint = uRL;
        this.authenticationToken = optional;
        this.setTimeoutToDefault();
    }

    public HttpsRequestDispatcher(URL uRL) {
        this(uRL, Optional.empty());
    }

    public HttpsRequestDispatcher(URL uRL, String string, String string2) {
        this(uRL, Optional.of(HttpsRequestDispatcher.createBasicAuthToken(string, string2)));
    }

    @Override
    public String getVersion() {
        return this.endpointVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dispatchRequest(String string) throws IOException {
        byte[] byArray = string.getBytes();
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)this.endpoint.openConnection();
        this.prepareConnection(httpsURLConnection);
        Closeable closeable = httpsURLConnection.getOutputStream();
        Object object = null;
        try {
            ((OutputStream)closeable).write(byArray);
            ((OutputStream)closeable).flush();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (closeable != null) {
                if (object != null) {
                    try {
                        ((OutputStream)closeable).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((OutputStream)closeable).close();
                }
            }
        }
        closeable = httpsURLConnection.getResponseCode() == 200 ? httpsURLConnection.getInputStream() : httpsURLConnection.getErrorStream();
        try {
            object = this.decodeResponse((InputStream)closeable);
            return object;
        }
        finally {
            if (null != closeable) {
                ((InputStream)closeable).close();
            }
        }
    }

    protected void prepareConnection(final HttpsURLConnection httpsURLConnection) {
        try {
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setDoOutput(true);
        }
        catch (ProtocolException protocolException) {
            throw new RuntimeException("Your HTTP connection does not support \"POST\"", protocolException);
        }
        httpsURLConnection.addRequestProperty("Accept", "application/json");
        httpsURLConnection.setConnectTimeout(this.connectionTimeout);
        httpsURLConnection.setReadTimeout(this.readTimeout);
        this.authenticationToken.ifPresent(new Consumer<String>(){

            @Override
            public void accept(String string) {
                httpsURLConnection.addRequestProperty("Authorization", string);
            }
        });
    }

    protected String decodeResponse(InputStream inputStream) throws IOException {
        try (Scanner scanner = new Scanner(inputStream);){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    private static String createBasicAuthToken(String string, String string2) {
        return "Basic " + Base64.encodeBytes((byte[])(string + ":" + string2).getBytes());
    }

    @Override
    public void setTimeoutToDefault() {
        this.connectionTimeout = 15000;
        this.readTimeout = 60000;
    }

    @Override
    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    @Override
    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    static {
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
    }
}

