/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.javautil;

import com.solidfire.jsvcgen.javautil.Consumer;
import com.solidfire.jsvcgen.javautil.Function;
import com.solidfire.jsvcgen.javautil.Predicate;
import com.solidfire.jsvcgen.javautil.Supplier;
import java.util.Map;
import java.util.NoSuchElementException;

public final class Optional<T> {
    public static final Optional<String> EMPTY_STRING = Optional.empty();
    public static final Optional<String[]> EMPTY_STRING_ARRAY = Optional.empty();
    public static final Optional<Long> EMPTY_LONG = Optional.empty();
    public static final Optional<Long[]> EMPTY_LONG_ARRAY = Optional.empty();
    public static final Optional<Double> EMPTY_DOUBLE = Optional.empty();
    public static final Optional<Double[]> EMPTY_DOUBLE_ARRAY = Optional.empty();
    public static final Optional<Map<String, Object>> EMPTY_MAP = Optional.empty();
    private final T value;
    private static final Optional<?> EMPTY = new Optional();

    private Optional() {
        this.value = null;
    }

    private Optional(T t) {
        if (t == null) {
            throw new NullPointerException("Cannot create Optional with a null value");
        }
        this.value = t;
    }

    public static <T> Optional<T> empty() {
        Optional<?> optional = EMPTY;
        return optional;
    }

    public static <T> Optional<T> of(T t) {
        if (t.getClass() == Optional.class) {
            return (Optional)t;
        }
        return new Optional<T>(t);
    }

    public static <T> Optional<T> ofNullable(T t) {
        if (t == null) {
            return Optional.empty();
        }
        return Optional.of(t);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Optional) {
            Optional optional = (Optional)object;
            if (this.value == null) {
                return optional.value == null;
            }
            if (optional.value == null) {
                return false;
            }
            return this.value.equals(optional.value);
        }
        return false;
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate cannot be null");
        }
        if (this.isPresent() && predicate.test(this.get())) {
            return this;
        }
        return Optional.empty();
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> function) {
        if (function == null) {
            throw new NullPointerException("mapper cannot be null");
        }
        if (this.isPresent()) {
            return function.apply(this.get());
        }
        return Optional.empty();
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("Cannot get an Optional without a value");
        }
        return this.value;
    }

    public int hashCode() {
        return this.isPresent() ? this.value.hashCode() : 0;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer cannot be null");
        }
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> function) {
        if (function == null) {
            throw new NullPointerException("mapper cannot be null");
        }
        if (this.isPresent()) {
            return new Optional<U>(function.apply(this.get()));
        }
        return Optional.empty();
    }

    public T orElse(T t) {
        if (this.isPresent()) {
            return this.value;
        }
        return t;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("other cannot be null");
        }
        if (this.isPresent()) {
            return this.value;
        }
        return supplier.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> supplier) throws X {
        if (supplier == null) {
            throw new NullPointerException("exceptionSupplier cannot be null");
        }
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)supplier.get();
    }

    public String toString() {
        return this.map(new Function<T, String>(){

            @Override
            public String apply(T t) {
                return "Some(" + t.toString() + ")";
            }
        }).orElse("None");
    }
}

