/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.serialization;

import com.solidfire.jsvcgen.javautil.Optional;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalAdaptorUtils {
    private static final Logger log = LoggerFactory.getLogger(OptionalAdaptorUtils.class);

    public static <T> T initializeAllNullOptionalFieldsAsEmpty(T t) {
        if (!OptionalAdaptorUtils.hasOptionalFields(t)) {
            return t;
        }
        for (Map.Entry<Field, Object> entry : OptionalAdaptorUtils.getOptionalFields(t).entrySet()) {
            try {
                Field field = entry.getKey();
                Object object = entry.getValue();
                boolean bl = field.isAccessible();
                field.setAccessible(true);
                if (field.get(object) == null) {
                    field.set(object, Optional.empty());
                }
                field.setAccessible(bl);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.debug("Error changing field {} in {}", (Object)entry.getKey().getName(), (Object)entry.getValue().getClass().getSimpleName());
            }
        }
        return t;
    }

    public static boolean hasOptionalFields(Object object) {
        if (object == null || object instanceof String) {
            return false;
        }
        if (object.getClass().isArray() && object.getClass().getComponentType().isPrimitive()) {
            return false;
        }
        if (object.getClass().isArray() && !object.getClass().isPrimitive()) {
            for (Object object2 : (Object[])object) {
                if (!OptionalAdaptorUtils.hasOptionalFields(object2)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                if (!OptionalAdaptorUtils.hasOptionalFields(t)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (!OptionalAdaptorUtils.hasOptionalFields(entry.getKey()) && !OptionalAdaptorUtils.hasOptionalFields(entry.getValue())) continue;
                return true;
            }
            return false;
        }
        for (Field field : object.getClass().getDeclaredFields()) {
            if (field.getType().isPrimitive() || field.getType().getName().startsWith("java.")) continue;
            if (field.getType() == Optional.class) {
                return true;
            }
            try {
                boolean bl = field.isAccessible();
                field.setAccessible(true);
                if (OptionalAdaptorUtils.hasOptionalFields(field.get(object))) {
                    return true;
                }
                field.setAccessible(bl);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.debug("Error searching for optional fields with {} in {}", (Object)field, (Object)object.getClass().getSimpleName());
            }
        }
        return false;
    }

    public static Map<Field, Object> getOptionalFields(Object object) {
        HashMap<Field, Object> hashMap = new HashMap<Field, Object>();
        if (object == null || object instanceof String) {
            return hashMap;
        }
        if (object.getClass().isArray() && !object.getClass().isPrimitive()) {
            for (Object object2 : (Object[])object) {
                if (!OptionalAdaptorUtils.hasOptionalFields(object2)) continue;
                hashMap.putAll(OptionalAdaptorUtils.getOptionalFields(object2));
            }
            return hashMap;
        }
        if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                if (!OptionalAdaptorUtils.hasOptionalFields(t)) continue;
                hashMap.putAll(OptionalAdaptorUtils.getOptionalFields(t));
            }
            return hashMap;
        }
        if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (OptionalAdaptorUtils.hasOptionalFields(entry.getKey())) {
                    hashMap.putAll(OptionalAdaptorUtils.getOptionalFields(entry.getKey()));
                }
                if (!OptionalAdaptorUtils.hasOptionalFields(entry.getValue())) continue;
                hashMap.putAll(OptionalAdaptorUtils.getOptionalFields(entry.getValue()));
            }
            return hashMap;
        }
        for (Field field : object.getClass().getDeclaredFields()) {
            if (field.getType().isPrimitive() || field.getType().getName().startsWith("java.")) continue;
            if (field.getType() == Optional.class) {
                hashMap.put(field, object);
                continue;
            }
            try {
                boolean bl = field.isAccessible();
                field.setAccessible(true);
                if (OptionalAdaptorUtils.hasOptionalFields(field.get(object))) {
                    hashMap.putAll(OptionalAdaptorUtils.getOptionalFields(field.get(object)));
                }
                field.setAccessible(bl);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.debug("Error gathering optional fields with {} in {}", (Object)field, (Object)object.getClass().getSimpleName());
            }
        }
        return hashMap;
    }
}

