/*
 * Decompiled with CFR 0.152.
 */
package com.sovren;

import com.sovren.SovrenClient;
import com.sovren.exceptions.SovrenException;
import com.sovren.models.api.bimetricscoring.BimetricScoreJobRequest;
import com.sovren.models.api.bimetricscoring.BimetricScoreResumeRequest;
import com.sovren.models.api.bimetricscoring.IParsedDocWithId;
import com.sovren.models.api.bimetricscoring.ParsedJobWithId;
import com.sovren.models.api.bimetricscoring.ParsedResumeWithId;
import com.sovren.models.api.matching.CategoryWeights;
import com.sovren.models.api.matching.MatchJobRequest;
import com.sovren.models.api.matching.MatchResumeRequest;
import com.sovren.models.api.matching.SearchRequest;
import com.sovren.models.api.matching.request.FilterCriteria;
import com.sovren.models.api.matching.request.MatchByDocumentIdOptions;
import com.sovren.models.api.matching.request.PaginationSettings;
import com.sovren.models.api.matching.request.SearchMatchSettings;
import com.sovren.models.api.matching.ui.GenerateUIResponse;
import com.sovren.models.api.matching.ui.request.MatchUISettings;
import com.sovren.models.api.matching.ui.request.UIBimetricScoreJobRequest;
import com.sovren.models.api.matching.ui.request.UIBimetricScoreResumeRequest;
import com.sovren.models.api.matching.ui.request.UIMatchByDocumentIdOptions;
import com.sovren.models.api.matching.ui.request.UIMatchJobRequest;
import com.sovren.models.api.matching.ui.request.UIMatchResumeRequest;
import com.sovren.models.api.matching.ui.request.UISearchRequest;
import com.sovren.models.job.ParsedJob;
import com.sovren.models.resume.ParsedResume;
import java.util.List;

public class SovrenUIClient {
    private final MatchUISettings _uiSessionOptions;
    private final SovrenClient _client;

    SovrenUIClient(MatchUISettings uiOptions, SovrenClient client) {
        this._uiSessionOptions = uiOptions;
        this._client = client;
    }

    public GenerateUIResponse match(ParsedResume resume, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws SovrenException {
        MatchResumeRequest request = this._client.createRequest(resume, indexesToQuery, preferredWeights, filters, settings, numResults);
        UIMatchResumeRequest uiRequest = new UIMatchResumeRequest(request, this._uiSessionOptions);
        return this._client.uiMatch(uiRequest);
    }

    public GenerateUIResponse match(ParsedJob job, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws SovrenException {
        MatchJobRequest request = this._client.createRequest(job, indexesToQuery, preferredWeights, filters, settings, numResults);
        UIMatchJobRequest uiRequest = new UIMatchJobRequest(request, this._uiSessionOptions);
        return this._client.uiMatch(uiRequest);
    }

    public GenerateUIResponse match(String indexId, String documentId, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws SovrenException {
        MatchByDocumentIdOptions request = this._client.createRequest(indexesToQuery, preferredWeights, filters, settings, numResults);
        UIMatchByDocumentIdOptions uiRequest = new UIMatchByDocumentIdOptions(request, this._uiSessionOptions);
        return this._client.uiMatch(indexId, documentId, uiRequest);
    }

    public GenerateUIResponse search(List<String> indexesToQuery, FilterCriteria query, SearchMatchSettings settings, PaginationSettings pagination) throws SovrenException {
        SearchRequest request = this._client.createRequest(indexesToQuery, query, settings, pagination);
        UISearchRequest uiRequest = new UISearchRequest(request, this._uiSessionOptions);
        return this._client.uiSearch(uiRequest);
    }

    public <TTarget extends IParsedDocWithId> GenerateUIResponse bimetricScore(ParsedResumeWithId sourceResume, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) throws SovrenException {
        BimetricScoreResumeRequest request = this._client.createRequest(sourceResume, targetDocuments, preferredWeights, settings);
        UIBimetricScoreResumeRequest uiRequest = new UIBimetricScoreResumeRequest(request, this._uiSessionOptions);
        return this._client.uiBimetricScore(uiRequest);
    }

    public <TTarget extends IParsedDocWithId> GenerateUIResponse bimetricScore(ParsedJobWithId sourceJob, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) throws SovrenException {
        BimetricScoreJobRequest request = this._client.createRequest(sourceJob, targetDocuments, preferredWeights, settings);
        UIBimetricScoreJobRequest uiRequest = new UIBimetricScoreJobRequest(request, this._uiSessionOptions);
        return this._client.uiBimetricScore(uiRequest);
    }
}

