/*
 * Decompiled with CFR 0.152.
 */
package com.sovren;

import com.sovren.DataCenter;

class ApiEndpoints {
    private static String _matchUIPrefix = "/ui";
    private DataCenter _dataCenter;

    ApiEndpoints(DataCenter dataCenter) {
        this._dataCenter = dataCenter;
    }

    private String prefix() {
        return this._dataCenter.Root + "/" + this._dataCenter.Version;
    }

    private String prefix(boolean isMatchUI) {
        if (!isMatchUI || !this._dataCenter.IsSovrenSaaS) {
            // empty if block
        }
        return this._dataCenter.Root + "/" + (isMatchUI ? _matchUIPrefix : "") + "/" + this._dataCenter.Version;
    }

    private String sanitize(String indexOrDocId) throws IllegalArgumentException {
        if (indexOrDocId == null || indexOrDocId.length() == 0) {
            throw new IllegalArgumentException("Index or document id is null or empty");
        }
        for (char c : indexOrDocId.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') continue;
            String charName = Character.isWhitespace(c) ? "whitespace" : String.valueOf(c);
            throw new IllegalArgumentException("Index or document id contains an invalid character: " + charName);
        }
        return indexOrDocId;
    }

    String account() {
        return this.prefix() + "/account";
    }

    String parseResume() {
        return this.prefix() + "/parser/resume";
    }

    String parseJob() {
        return this.prefix() + "/parser/joborder";
    }

    String index(String id) {
        return this.prefix() + "/index/" + this.sanitize(id);
    }

    String indexDocumentCount(String id) {
        return this.prefix() + "/index/" + this.sanitize(id) + "/count";
    }

    String allIndexes() {
        return this.prefix() + "/index";
    }

    String resume(String indexId, String docId) {
        return this.prefix() + "/index/" + this.sanitize(indexId) + "/resume/" + this.sanitize(docId);
    }

    String job(String indexId, String docId) {
        return this.prefix() + "/index/" + this.sanitize(indexId) + "/joborder/" + this.sanitize(docId);
    }

    String multipleResumes(String indexId) {
        return this.prefix() + "/index/" + this.sanitize(indexId) + "/resumes";
    }

    String multipleJobs(String indexId) {
        return this.prefix() + "/index/" + this.sanitize(indexId) + "/joborders";
    }

    String document(String indexId, String docId) {
        return this.prefix() + "/index/" + this.sanitize(indexId) + "/documents/" + this.sanitize(docId);
    }

    String multipleDocuments(String indexId) {
        return this.prefix() + "/index/" + this.sanitize(indexId) + "/documents";
    }

    String matchResume(boolean isMatchUI) {
        return this.prefix(isMatchUI) + "/matcher/resume";
    }

    String matchJob(boolean isMatchUI) {
        return this.prefix(isMatchUI) + "/matcher/joborder";
    }

    String matchDocId(String indexId, String docId, boolean isMatchUI) {
        return this.prefix(isMatchUI) + "/matcher/indexes/" + this.sanitize(indexId) + "/documents/" + this.sanitize(docId);
    }

    String search(boolean isMatchUI) {
        return this.prefix(isMatchUI) + "/searcher";
    }

    String bimetricScoreResume(boolean isMatchUI) {
        return this.prefix(isMatchUI) + "/scorer/bimetric/resume";
    }

    String bimetricScoreJob(boolean isMatchUI) {
        return this.prefix(isMatchUI) + "/scorer/bimetric/joborder";
    }

    String geocodeResume() {
        return this.prefix() + "/geocoder/resume";
    }

    String geocodeJob() {
        return this.prefix() + "/geocoder/joborder";
    }

    String geocodeAndIndexResume() {
        return this.prefix() + "/geocodeAndIndex/resume";
    }

    String geocodeAndIndexJob() {
        return this.prefix() + "/geocodeAndIndex/joborder";
    }
}

