/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackify.api.LogMsgGroup;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.http.HttpClient;
import com.stackify.api.common.http.HttpException;
import com.stackify.api.common.http.HttpResendQueue;
import com.stackify.api.common.util.Preconditions;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogSender.class);
    private static final String LOG_SAVE_PATH = "/Log/Save";
    private final ApiConfiguration apiConfig;
    private final ObjectMapper objectMapper;
    private final HttpResendQueue resendQueue = new HttpResendQueue(100);

    public LogSender(ApiConfiguration apiConfig, ObjectMapper objectMapper) {
        Preconditions.checkNotNull(apiConfig);
        Preconditions.checkNotNull(objectMapper);
        this.apiConfig = apiConfig;
        this.objectMapper = objectMapper;
    }

    public int send(LogMsgGroup group) throws IOException {
        Preconditions.checkNotNull(group);
        HttpClient httpClient = new HttpClient(this.apiConfig);
        this.resendQueue.drain(httpClient, LOG_SAVE_PATH, true);
        byte[] jsonBytes = this.objectMapper.writer().writeValueAsBytes((Object)group);
        int statusCode = 500;
        try {
            httpClient.post(LOG_SAVE_PATH, jsonBytes, true);
            statusCode = 200;
        }
        catch (IOException t) {
            LOGGER.info("Queueing logs for retransmission due to IOException");
            this.resendQueue.offer(jsonBytes, t);
            throw t;
        }
        catch (HttpException e) {
            statusCode = e.getStatusCode();
            LOGGER.info("Queueing logs for retransmission due to HttpException", (Throwable)e);
            this.resendQueue.offer(jsonBytes, e);
        }
        return statusCode;
    }
}

